/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.ZoneId;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;

public class ListConnectionResult {
    @Description(value="The id of the connection.")
    public final String connectionId;
    @Description(value="The time the connection was established, formatted according to the ISO-8601 Standard.")
    public final String connectTime;
    @Description(value="The protocol of the connector.")
    public final String connector;
    @Description(value="The username of the connected user.")
    public final String username;
    @Description(value="The active agent.")
    public final String userAgent;
    @Description(value="The address of the connected server.")
    public final String serverAddress;
    @Description(value="The address of the connected client.")
    public final String clientAddress;

    ListConnectionResult(TrackedNetworkConnection connection, ZoneId timeZone) {
        this.connectionId = connection.id();
        this.connectTime = ProceduresTimeFormatHelper.formatTime(connection.connectTime(), timeZone);
        this.connector = connection.connectorId();
        this.username = connection.username();
        this.userAgent = connection.userAgent();
        this.serverAddress = SocketAddress.format((java.net.SocketAddress)connection.serverAddress());
        this.clientAddress = SocketAddress.format((java.net.SocketAddress)connection.clientAddress());
    }
}

