/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `ZONED DATETIME` instant.")
class DateTimeFunction
extends TemporalFunction<DateTimeValue> {
    private static final String CATEGORY = Category.TEMPORAL();
    private static final List<FieldSignature> INPUT_SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('year', 'month', 'day', 'hour', 'minute', 'second', 'millisecond', 'microsecond', 'nanosecond', 'timezone', 'epochSeconds', 'epochMillis') as components."));

    DateTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, INPUT_SIGNATURE, defaultZone);
    }

    @Override
    protected DateTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateTimeValue.now((Clock)clock, defaultZone) : DateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected List<FieldSignature> getTemporalTruncateSignature() {
        return Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (String)"A string representing one of the following: 'microsecond', 'millisecond', 'second', 'minute', 'hour', 'day', 'week', 'month', 'weekYear', 'quarter', 'year', 'decade', 'century', 'millennium'."), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"The date to be truncated using either `ZONED DATETIME`, `LOCAL DATETIME`, or `DATE`."), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap), (boolean)false, (String)"A list of time components smaller than those specified in `unit` to preserve during truncation."));
    }

    @Override
    protected DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    void registerMore(GlobalProcedures globalProcedures) throws ProcedureException {
        globalProcedures.register((CallableUserFunction)new FromEpoch());
        globalProcedures.register((CallableUserFunction)new FromEpochMillis());
    }

    @Override
    protected String getTemporalCypherTypeName() {
        return "ZONED DATETIME";
    }

    private static class FromEpoch
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Creates a `ZONED DATETIME` given the seconds and nanoseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"seconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber, (String)"The number of seconds from the UNIX epoch in the UTC time zone."), FieldSignature.inputField((String)"nanoseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber, (String)"The number of nanoseconds from the UNIX epoch in the UTC time zone. This can be added to seconds."));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName("datetime", "fromepoch"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, false, null, "Creates a `ZONED DATETIME` given the seconds and nanoseconds since the start of the epoch.", CATEGORY, true, true, false, true);

        private FromEpoch() {
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 2) {
                AnyValue anyValue = input[0];
                if (anyValue instanceof IntegralValue) {
                    IntegralValue seconds = (IntegralValue)anyValue;
                    anyValue = input[1];
                    if (anyValue instanceof IntegralValue) {
                        IntegralValue nanoseconds = (IntegralValue)anyValue;
                        return DateTimeValue.ofEpoch((IntegralValue)seconds, (IntegralValue)nanoseconds);
                    }
                }
                throw ProcedureException.invalidCallSignature((String)this.getClass().getSimpleName(), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
            }
            throw ProcedureException.invalidNumberOfProcedureOrFunctionArguments((Number)2, (Number)(input == null ? 0 : input.length), (String)this.getClass().getSimpleName(), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
    }

    private static class FromEpochMillis
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Creates a `ZONED DATETIME` given the milliseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"milliseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber, (String)"The number of milliseconds from the UNIX epoch in the UTC time zone."));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName("datetime", "fromepochmillis"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, false, null, "Creates a `ZONED DATETIME` given the milliseconds since the start of the epoch.", CATEGORY, true, true, false, true);

        private FromEpochMillis() {
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 1) {
                AnyValue anyValue = input[0];
                if (anyValue instanceof IntegralValue) {
                    IntegralValue milliseconds = (IntegralValue)anyValue;
                    return DateTimeValue.ofEpochMillis((IntegralValue)milliseconds);
                }
                throw ProcedureException.invalidCallSignature((String)this.getClass().getSimpleName(), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
            }
            throw ProcedureException.invalidNumberOfProcedureOrFunctionArguments((Number)1, (Number)(input == null ? 0 : input.length), (String)this.getClass().getSimpleName(), (String)this.signature.toString(), (String)("Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input)));
        }
    }
}

