/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.memory;

import org.neo4j.collection.trackable.HeapTracking;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.impl.memory.ProcedureHeapEstimator;
import org.neo4j.procedure.impl.memory.ProcedureMemoryTrackerImpl;
import org.neo4j.procedure.memory.HeapEstimator;
import org.neo4j.procedure.memory.ProcedureMemory;
import org.neo4j.procedure.memory.ProcedureMemoryTracker;

class ProcedureMemoryImpl
implements ProcedureMemory {
    private final MemoryTracker innerTracker;

    ProcedureMemoryImpl(MemoryTracker txMemoryTracker) {
        this.innerTracker = txMemoryTracker;
    }

    public ProcedureMemoryTracker newTracker() {
        return new ProcedureMemoryTrackerImpl(this.innerTracker.getScopedMemoryTracker());
    }

    public HeapEstimator heapEstimator() {
        return ProcedureHeapEstimator.INSTANCE;
    }

    public ProcedureMemory.HeapTrackingCollectionFactory collections() {
        return new ProcedureMemory.HeapTrackingCollectionFactory(){

            public <V> HeapTracking.List<V> newHeapTrackingArrayList() {
                return HeapTrackingArrayList.newArrayList((MemoryTracker)ProcedureMemoryImpl.this.innerTracker);
            }

            public <V> HeapTracking.List<V> newHeapTrackingArrayList(int initialCapacity) {
                return HeapTrackingArrayList.newArrayList((int)initialCapacity, (MemoryTracker)ProcedureMemoryImpl.this.innerTracker);
            }

            public <K, V> HeapTracking.Map<K, V> newHeapTrackingUnifiedMap() {
                return HeapTrackingUnifiedMap.createUnifiedMap((MemoryTracker)ProcedureMemoryImpl.this.innerTracker);
            }

            public <K, V> HeapTracking.Map<K, V> newHeapTrackingUnifiedMap(int initialCapacity) {
                return HeapTrackingUnifiedMap.createUnifiedMap((int)initialCapacity, (MemoryTracker)ProcedureMemoryImpl.this.innerTracker);
            }
        };
    }
}

