/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.neo4j.procedure.builtin.graphschema.GraphSchema;

final class GraphSchemaModule
extends SimpleModule {
    private static final long serialVersionUID = -4886300307467434436L;
    private static volatile ObjectMapper OBJECT_MAPPER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ObjectMapper getGraphSchemaObjectMapper() {
        ObjectMapper result = OBJECT_MAPPER;
        if (result != null) return result;
        Class<GraphSchemaModule> clazz = GraphSchemaModule.class;
        synchronized (GraphSchemaModule.class) {
            result = OBJECT_MAPPER;
            if (result != null) return result;
            OBJECT_MAPPER = new ObjectMapper();
            OBJECT_MAPPER.registerModule((Module)new GraphSchemaModule());
            return OBJECT_MAPPER;
        }
    }

    static String asJsonString(List<GraphSchema.Property> properties) {
        try {
            return GraphSchemaModule.getGraphSchemaObjectMapper().writeValueAsString(properties);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private GraphSchemaModule() {
        this.addSerializer(GraphSchema.Type.class, (JsonSerializer)new TypeSerializer());
        this.addSerializer(GraphSchema.class, (JsonSerializer)new GraphSchemaSerializer());
        this.addSerializer(GraphSchema.Ref.class, (JsonSerializer)new RefSerializer());
        this.setMixInAnnotation(GraphSchema.Property.class, PropertyMixin.class);
        this.setMixInAnnotation(GraphSchema.NodeObjectType.class, NodeObjectTypeMixin.class);
        this.setMixInAnnotation(GraphSchema.Token.class, TokenMixin.class);
        this.setMixInAnnotation(GraphSchema.RelationshipObjectType.class, RelationshipObjectTypeMixin.class);
    }

    private static final class TypeSerializer
    extends StdSerializer<GraphSchema.Type> {
        private static final long serialVersionUID = -1260953273076427362L;

        TypeSerializer() {
            super(GraphSchema.Type.class);
        }

        public void serialize(GraphSchema.Type type, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", type.value());
            if (type.value().equals("array")) {
                gen.writeObjectFieldStart("items");
                gen.writeStringField("type", type.itemType());
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
    }

    private static final class GraphSchemaSerializer
    extends StdSerializer<GraphSchema> {
        private static final long serialVersionUID = 3421593591346480162L;

        GraphSchemaSerializer() {
            super(GraphSchema.class);
        }

        public void serialize(GraphSchema value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectFieldStart("graphSchemaRepresentation");
            gen.writeFieldName("graphSchema");
            gen.writeStartObject();
            this.writeArray(gen, "nodeLabels", value.nodeLabels().values());
            this.writeArray(gen, "relationshipTypes", value.relationshipTypes().values());
            this.writeArray(gen, "nodeObjectTypes", value.nodeObjectTypes().values());
            this.writeArray(gen, "relationshipObjectTypes", value.relationshipObjectTypes().values());
            gen.writeEndObject();
            gen.writeEndObject();
            gen.writeEndObject();
        }

        private void writeArray(JsonGenerator gen, String fieldName, Collection<?> items) throws IOException {
            gen.writeArrayFieldStart(fieldName);
            for (Object item : items) {
                gen.writeObject(item);
            }
            gen.writeEndArray();
        }
    }

    private static final class RefSerializer
    extends StdSerializer<GraphSchema.Ref> {
        private static final long serialVersionUID = -3928051476420574836L;

        RefSerializer() {
            super(GraphSchema.Ref.class);
        }

        public void serialize(GraphSchema.Ref value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("$ref", (Object)("#" + value.value()));
            gen.writeEndObject();
        }
    }

    @JsonPropertyOrder(value={"token", "type", "nullable"})
    private static abstract class PropertyMixin {
        private PropertyMixin() {
        }

        @JsonProperty(value="type")
        @JsonSerialize(using=TypeListSerializer.class)
        abstract List<GraphSchema.Type> types();

        @JsonProperty(value="nullable")
        @JsonSerialize(using=InvertingBooleanSerializer.class)
        abstract boolean mandatory();
    }

    @JsonPropertyOrder(value={"id", "labels", "properties"})
    private static abstract class NodeObjectTypeMixin {
        private NodeObjectTypeMixin() {
        }

        @JsonProperty(value="$id")
        abstract String id();
    }

    @JsonPropertyOrder(value={"id", "value"})
    private static abstract class TokenMixin {
        private TokenMixin() {
        }

        @JsonProperty(value="$id")
        abstract String id();

        @JsonProperty(value="token")
        abstract String value();
    }

    @JsonPropertyOrder(value={"id", "type", "from", "to", "properties"})
    private static abstract class RelationshipObjectTypeMixin {
        private RelationshipObjectTypeMixin() {
        }

        @JsonProperty(value="$id")
        abstract String id();
    }

    private static final class TypeListSerializer
    extends StdSerializer<List<GraphSchema.Type>> {
        private static final long serialVersionUID = -8831424337461613203L;

        TypeListSerializer() {
            super(TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<List<GraphSchema.Type>>(){}));
        }

        public void serialize(List<GraphSchema.Type> types, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            if (types.isEmpty()) {
                gen.writeNull();
            } else if (types.size() == 1) {
                gen.writeObject((Object)types.get(0));
            } else {
                gen.writeObject(types);
            }
        }
    }

    private static class InvertingBooleanSerializer
    extends StdSerializer<Boolean> {
        private static final long serialVersionUID = 6272997898442893145L;

        InvertingBooleanSerializer() {
            super(Boolean.class);
        }

        public void serialize(Boolean value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeBoolean(!Boolean.TRUE.equals(value));
        }
    }
}

