/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnalyzerProvider;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.util.FeatureToggles;

public class FulltextProcedures {
    private static final long INDEX_ONLINE_QUERY_TIMEOUT_SECONDS = FeatureToggles.getInteger(FulltextProcedures.class, (String)"INDEX_ONLINE_QUERY_TIMEOUT_SECONDS", (int)30);
    @Context
    public KernelTransaction tx;
    @Context
    public Transaction transaction;
    @Context
    public GraphDatabaseAPI db;
    @Context
    public DependencyResolver resolver;
    @Context
    public FulltextAdapter accessor;
    @Context
    public ProcedureCallContext callContext;

    @SystemProcedure
    @Description(value="List the available analyzers that the full-text indexes can be configured with.")
    @Procedure(name="db.index.fulltext.listAvailableAnalyzers", mode=Mode.READ)
    public Stream<AvailableAnalyzer> listAvailableAnalyzers() {
        return this.accessor.listAvailableAnalyzers().map(AvailableAnalyzer::new);
    }

    @SystemProcedure
    @Description(value="Wait for the updates from recently committed transactions to be applied to any eventually-consistent full-text indexes.")
    @Procedure(name="db.index.fulltext.awaitEventuallyConsistentIndexRefresh", mode=Mode.READ)
    public void awaitRefresh() {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        this.accessor.awaitRefresh();
    }

    @SystemProcedure
    @Description(value="Query the given full-text index. Returns the matching nodes, and their Lucene query score, ordered by score. Valid keys for the options map are: 'skip' to skip the top N results; 'limit' to limit the number of results returned; 'analyzer' to use the specified analyzer as search analyzer for this query.")
    @Procedure(name="db.index.fulltext.queryNodes", mode=Mode.READ)
    public Stream<NodeOutput> queryFulltextForNodes(@Name(value="indexName") String name, @Name(value="queryString") String query, @Name(value="options", defaultValue="{}") Map<String, Object> options) throws Exception {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        IndexDescriptor indexReference = this.getValidIndex(name);
        this.awaitOnline(indexReference);
        EntityType entityType = indexReference.schema().entityType();
        if (entityType != EntityType.NODE) {
            throw new IllegalArgumentException("The '" + name + "' index (" + indexReference + ") is an index on " + entityType + ", so it cannot be queried for nodes.");
        }
        final NodeValueIndexCursor cursor = this.tx.cursors().allocateNodeValueIndexCursor(this.tx.cursorContext(), this.tx.memoryTracker());
        IndexReadSession indexSession = this.tx.dataRead().indexReadSession(indexReference);
        IndexQueryConstraints constraints = FulltextProcedures.queryConstraints(options);
        this.tx.dataRead().nodeIndexSeek(this.tx.queryContext(), indexSession, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query, (String)FulltextProcedures.queryAnalyzer(options))});
        SpliteratorAdaptor<NodeOutput> spliterator = new SpliteratorAdaptor<NodeOutput>(){

            @Override
            public boolean tryAdvance(Consumer<? super NodeOutput> action) {
                while (cursor.next()) {
                    float score;
                    long nodeReference = cursor.nodeReference();
                    NodeOutput nodeOutput = NodeOutput.forExistingEntityOrNull(FulltextProcedures.this.transaction, nodeReference, score = cursor.score());
                    if (nodeOutput == null) continue;
                    action.accept(nodeOutput);
                    return true;
                }
                cursor.close();
                return false;
            }
        };
        Stream<NodeOutput> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(() -> ((NodeValueIndexCursor)cursor).close());
    }

    protected static IndexQueryConstraints queryConstraints(Map<String, Object> options) {
        Object limit;
        IndexQueryConstraints constraints = IndexQueryConstraints.unconstrained();
        Object skip = options.get("skip");
        if (skip != null && skip instanceof Number) {
            constraints = constraints.skip(((Number)skip).longValue());
        }
        if ((limit = options.get("limit")) != null && limit instanceof Number) {
            constraints = constraints.limit(((Number)limit).longValue());
        }
        return constraints;
    }

    protected static String queryAnalyzer(Map<String, Object> options) {
        Object analyzer = options.get("analyzer");
        if (analyzer != null && analyzer instanceof String) {
            return (String)analyzer;
        }
        return null;
    }

    @SystemProcedure
    @Description(value="Query the given full-text index. Returns the matching relationships, and their Lucene query score, ordered by score. Valid keys for the options map are: 'skip' to skip the top N results; 'limit' to limit the number of results returned; 'analyzer' to use the specified analyzer as search analyzer for this query.")
    @Procedure(name="db.index.fulltext.queryRelationships", mode=Mode.READ)
    public Stream<RelationshipOutput> queryFulltextForRelationships(@Name(value="indexName") String name, @Name(value="queryString") String query, @Name(value="options", defaultValue="{}") Map<String, Object> options) throws Exception {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        IndexDescriptor indexReference = this.getValidIndex(name);
        this.awaitOnline(indexReference);
        EntityType entityType = indexReference.schema().entityType();
        if (entityType != EntityType.RELATIONSHIP) {
            throw new IllegalArgumentException("The '" + name + "' index (" + indexReference + ") is an index on " + entityType + ", so it cannot be queried for relationships.");
        }
        final RelationshipValueIndexCursor cursor = this.tx.cursors().allocateRelationshipValueIndexCursor(this.tx.cursorContext(), this.tx.memoryTracker());
        IndexReadSession indexReadSession = this.tx.dataRead().indexReadSession(indexReference);
        IndexQueryConstraints constraints = FulltextProcedures.queryConstraints(options);
        this.tx.dataRead().relationshipIndexSeek(this.tx.queryContext(), indexReadSession, cursor, constraints, new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query, (String)FulltextProcedures.queryAnalyzer(options))});
        SpliteratorAdaptor<RelationshipOutput> spliterator = new SpliteratorAdaptor<RelationshipOutput>(){

            @Override
            public boolean tryAdvance(Consumer<? super RelationshipOutput> action) {
                while (cursor.next()) {
                    float score;
                    long relationshipReference = cursor.relationshipReference();
                    RelationshipOutput relationshipOutput = RelationshipOutput.forExistingEntityOrNull(FulltextProcedures.this.transaction, relationshipReference, score = cursor.score());
                    if (relationshipOutput == null) continue;
                    action.accept(relationshipOutput);
                    return true;
                }
                cursor.close();
                return false;
            }
        };
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> ((RelationshipValueIndexCursor)cursor).close());
    }

    private IndexDescriptor getValidIndex(@Name(value="indexName") String name) {
        IndexDescriptor indexReference = this.tx.schemaRead().indexGetForName(name);
        if (indexReference == IndexDescriptor.NO_INDEX || indexReference.getIndexType() != IndexType.FULLTEXT) {
            throw new IllegalArgumentException("There is no such fulltext schema index: " + name);
        }
        return indexReference;
    }

    private void awaitOnline(IndexDescriptor index) {
        KernelTransactionImplementation txImpl = (KernelTransactionImplementation)this.tx;
        if (!txImpl.hasTxStateWithChanges() || !txImpl.txState().indexDiffSetsBySchema(index.schema()).isAdded((Object)index)) {
            Schema schema = this.transaction.schema();
            schema.awaitIndexOnline(index.getName(), INDEX_ONLINE_QUERY_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
    }

    public static final class AvailableAnalyzer {
        public final String analyzer;
        public final String description;
        public final List<String> stopwords;

        AvailableAnalyzer(AnalyzerProvider provider) {
            this.analyzer = provider.getName();
            this.description = provider.description();
            this.stopwords = provider.stopwords();
        }
    }

    public static final class RelationshipOutput
    implements Comparable<RelationshipOutput> {
        public final Relationship relationship;
        public final double score;

        public RelationshipOutput(Relationship relationship, float score) {
            this.relationship = relationship;
            this.score = score;
        }

        public static RelationshipOutput forExistingEntityOrNull(Transaction transaction, long relationshipId, float score) {
            try {
                return new RelationshipOutput(transaction.getRelationshipById(relationshipId), score);
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }

        @Override
        public int compareTo(RelationshipOutput that) {
            return Double.compare(that.score, this.score);
        }

        public String toString() {
            return "ScoredRelationship(" + this.relationship + ", score=" + this.score + ")";
        }
    }

    public static final class NodeOutput
    implements Comparable<NodeOutput> {
        public final Node node;
        public final double score;

        public NodeOutput(Node node, float score) {
            this.node = node;
            this.score = score;
        }

        public static NodeOutput forExistingEntityOrNull(Transaction transaction, long nodeId, float score) {
            try {
                return new NodeOutput(transaction.getNodeById(nodeId), score);
            }
            catch (NotFoundException ignore) {
                return null;
            }
        }

        @Override
        public int compareTo(NodeOutput that) {
            return Double.compare(that.score, this.score);
        }

        public String toString() {
            return "ScoredNode(" + this.node + ", score=" + this.score + ")";
        }
    }

    private static abstract class SpliteratorAdaptor<T>
    implements Spliterator<T> {
        private SpliteratorAdaptor() {
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1301;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return null;
        }
    }
}

