/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.ProcedureRegistry;
import org.neo4j.string.Globbing;
import org.neo4j.values.AnyValue;

public class ProcedureViewImpl
implements ProcedureView {
    private static final int LOOKUP_CACHE_SIZE = 100;
    private final long signatureVersion;
    private final ProcedureRegistry registry;
    private final ComponentRegistry safeComponents;
    private final ComponentRegistry allComponents;
    private final LfuCache<String, int[]> proceduresLookupCache = new LfuCache("procedures", 100);
    private final LfuCache<String, int[]> functionsLookupCache = new LfuCache("functions", 100);
    private final LfuCache<String, int[]> aggregationFunctionsLookupCache = new LfuCache("aggregationFunctions", 100);

    private ProcedureViewImpl(long signatureVersion, ProcedureRegistry registryView, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        this.signatureVersion = signatureVersion;
        this.registry = registryView;
        this.safeComponents = safeComponents;
        this.allComponents = allComponents;
    }

    public static ProcedureView snapshot(long signatureVersion, ProcedureRegistry registry, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        return new ProcedureViewImpl(signatureVersion, ProcedureRegistry.copyOf(registry), ComponentRegistry.copyOf(safeComponents), ComponentRegistry.copyOf(allComponents));
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
        ComponentRegistry registryView = safe ? this.safeComponents : this.allComponents;
        return registryView.providerFor(cls);
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        return this.registry.procedure(name);
    }

    public UserFunctionHandle function(QualifiedName name) {
        return this.registry.function(name);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        return this.registry.aggregationFunction(name);
    }

    public int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        return this.registry.getIdsOfFunctionsMatching(predicate);
    }

    public int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        return this.registry.getIdsOfAggregatingFunctionsMatching(predicate);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.registry.getAllProcedures();
    }

    public int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        return this.registry.getIdsOfProceduresMatching(predicate);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.registry.getAllNonAggregatingFunctions();
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.registry.getAllAggregatingFunctions();
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        return this.registry.callProcedure(ctx, id, input, resourceMonitor);
    }

    public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
        return this.registry.callFunction(ctx, id, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, id);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        int[] cachedResult = (int[])this.proceduresLookupCache.get((Object)procedureGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)procedureGlobbing);
        int[] data = this.getIdsOfProceduresMatching(p -> matcherPredicate.test(p.signature().name().toString()));
        this.proceduresLookupCache.put((Object)procedureGlobbing, (Object)data);
        return data;
    }

    public int[] getAdminProcedureIds() {
        return this.getIdsOfProceduresMatching(p -> p.signature().admin());
    }

    public int[] getFunctionIds(String functionGlobbing) {
        int[] cachedResult = (int[])this.functionsLookupCache.get((Object)functionGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        int[] data = this.getIdsOfFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
        this.functionsLookupCache.put((Object)functionGlobbing, (Object)data);
        return data;
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        int[] cachedResult = (int[])this.aggregationFunctionsLookupCache.get((Object)functionGlobbing);
        if (cachedResult != null) {
            return cachedResult;
        }
        Predicate matcherPredicate = Globbing.globPredicate((String)functionGlobbing);
        int[] data = this.getIdsOfAggregatingFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
        this.aggregationFunctionsLookupCache.put((Object)functionGlobbing, (Object)data);
        return data;
    }

    public long signatureVersion() {
        return this.signatureVersion;
    }
}

