/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

class ProcedureHolder<T> {
    private final Map<QualifiedName, Integer> nameToId;
    private final Map<QualifiedName, Integer> caseInsensitiveName2Id;
    private final List<Object> store;
    private static final Object TOMBSTONE = new Object(){

        public String toString() {
            return "TOMBSTONE";
        }
    };

    public ProcedureHolder() {
        this(new HashMap<QualifiedName, Integer>(), new HashMap<QualifiedName, Integer>(), new ArrayList<Object>());
    }

    private ProcedureHolder(Map<QualifiedName, Integer> nameToId, Map<QualifiedName, Integer> caseInsensitiveName2Id, List<Object> store) {
        this.nameToId = nameToId;
        this.caseInsensitiveName2Id = caseInsensitiveName2Id;
        this.store = store;
    }

    T get(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null) {
            return null;
        }
        Object value = this.store.get(id);
        if (value == TOMBSTONE) {
            return null;
        }
        return (T)value;
    }

    T get(int id) {
        Object element = this.store.get(id);
        if (element == TOMBSTONE) {
            return null;
        }
        return (T)element;
    }

    int put(QualifiedName name, T item, boolean caseInsensitive) {
        Integer id = this.name2Id(name);
        if (id != null) {
            this.store.set(id, item);
        } else {
            id = this.store.size();
            this.nameToId.put(name, id);
            this.store.add(item);
        }
        QualifiedName lowercaseName = this.toLowerCaseName(name);
        if (caseInsensitive) {
            this.caseInsensitiveName2Id.put(lowercaseName, id);
        } else {
            this.caseInsensitiveName2Id.remove(lowercaseName);
        }
        return id;
    }

    public static <T> ProcedureHolder<T> tombstone(ProcedureHolder<T> src, Predicate<QualifiedName> which) {
        Objects.requireNonNull(which);
        ProcedureHolder<T> ret = new ProcedureHolder<T>();
        Set matches = src.nameToId.entrySet().stream().filter(entry -> which.test((QualifiedName)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        for (int i = 0; i < src.store.size(); ++i) {
            if (matches.contains(i)) {
                ret.store.add(TOMBSTONE);
                continue;
            }
            ret.store.add(src.store.get(i));
        }
        ret.caseInsensitiveName2Id.putAll(src.caseInsensitiveName2Id);
        ret.nameToId.putAll(src.nameToId);
        return ret;
    }

    int idOf(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null || this.store.get(id) == TOMBSTONE) {
            throw new NoSuchElementException();
        }
        return id;
    }

    List<T> all() {
        return this.store.stream().filter(e -> e != TOMBSTONE).collect(Collectors.toList());
    }

    boolean contains(QualifiedName name) {
        return this.get(name) != null;
    }

    private Integer name2Id(QualifiedName name) {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            QualifiedName lowerCaseName = this.toLowerCaseName(name);
            id = this.caseInsensitiveName2Id.get(lowerCaseName);
        }
        return id;
    }

    private QualifiedName toLowerCaseName(QualifiedName name) {
        String[] oldNs = name.namespace();
        String[] lowerCaseNamespace = new String[oldNs.length];
        for (int i = 0; i < oldNs.length; ++i) {
            lowerCaseNamespace[i] = oldNs[i].toLowerCase(Locale.ROOT);
        }
        String lowercaseName = name.name().toLowerCase(Locale.ROOT);
        return new QualifiedName(lowerCaseNamespace, lowercaseName);
    }

    public void unregister(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id != null) {
            this.store.set(id, TOMBSTONE);
        }
    }

    public static <T> ProcedureHolder<T> copyOf(ProcedureHolder<T> ref) {
        return new ProcedureHolder<T>(Map.copyOf(ref.nameToId), Map.copyOf(ref.caseInsensitiveName2Id), List.copyOf(ref.store));
    }
}

