/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.impl.TypeCheckers;

class ProcedureOutputSignatureCompiler {
    private final TypeCheckers typeCheckers;

    ProcedureOutputSignatureCompiler(TypeCheckers typeCheckers) {
        this.typeCheckers = typeCheckers;
    }

    List<FieldSignature> fieldSignatures(Method method) throws ProcedureException {
        Class<?> cls = method.getReturnType();
        if (cls == Void.class || cls == Void.TYPE) {
            return ProcedureSignature.VOID;
        }
        if (cls != Stream.class) {
            throw this.invalidReturnType(cls);
        }
        Type genericReturnType = method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a raw Stream.", new Object[0]);
        }
        ParameterizedType genType = (ParameterizedType)genericReturnType;
        Type recordType = genType.getActualTypeArguments()[0];
        if (recordType instanceof WildcardType) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a Stream<?>.", new Object[0]);
        }
        if (recordType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)recordType;
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a parameterized type such as %s.", new Object[]{type});
        }
        return this.fieldSignatures((Class)recordType);
    }

    List<FieldSignature> fieldSignatures(Class<?> userClass) throws ProcedureException {
        this.assertIsValidRecordClass(userClass);
        List<Field> fields = ProcedureOutputSignatureCompiler.instanceFields(userClass);
        FieldSignature[] signature = new FieldSignature[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!userClass.isRecord() && !Modifier.isPublic(field.getModifiers())) {
                throw new ProcedureException((Status)Status.Procedure.TypeError, "Field `%s` in record `%s` cannot be accessed. Please ensure the field is marked as `public`.", new Object[]{field.getName(), userClass.getSimpleName()});
            }
            try {
                TypeCheckers.TypeChecker checker = this.typeCheckers.checkerFor(field.getGenericType());
                signature[i] = FieldSignature.outputField((String)field.getName(), (Neo4jTypes.AnyType)checker.type(), (boolean)field.isAnnotationPresent(Deprecated.class));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), (Throwable)e, "Field `%s` in record `%s` cannot be converted to a Neo4j type: %s", new Object[]{field.getName(), userClass.getSimpleName(), e.getMessage()});
            }
        }
        return Arrays.asList(signature);
    }

    private void assertIsValidRecordClass(Class<?> userClass) throws ProcedureException {
        if (userClass.isPrimitive() || userClass.isArray() || userClass.getPackage() != null && userClass.getPackage().getName().startsWith("java.")) {
            throw this.invalidReturnType(userClass);
        }
    }

    private ProcedureException invalidReturnType(Class<?> userClass) {
        return new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `%s`, you could define a record class like:%npublic class Output '{'%n    public %s out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[]{userClass.getSimpleName(), userClass.getSimpleName()});
    }

    static List<Field> instanceFields(Class<?> userClass) {
        return Stream.iterate(userClass, Predicate.not(ProcedureOutputSignatureCompiler::isJavaLangClass), Class::getSuperclass).flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.isSynthetic()).toList();
    }

    private static boolean isJavaLangClass(Class<?> cls) {
        return cls.getPackage().getName().equals("java.lang");
    }
}

