/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;

public class SchemaProcedure {
    private final InternalTransaction internalTransaction;

    public SchemaProcedure(InternalTransaction internalTransaction) {
        this.internalTransaction = internalTransaction;
    }

    public GraphResult buildSchemaGraph() {
        HashMap<String, VirtualNodeHack> nodes = new HashMap<String, VirtualNodeHack>();
        HashMap<String, Set<VirtualRelationshipHack>> relationships = new HashMap<String, Set<VirtualRelationshipHack>>();
        KernelTransaction kernelTransaction = this.internalTransaction.kernelTransaction();
        AccessMode mode = kernelTransaction.securityContext().mode();
        try (KernelTransaction.Revertable ignore = kernelTransaction.overrideWith(SecurityContext.AUTH_DISABLED);){
            Read dataRead = kernelTransaction.dataRead();
            TokenRead tokenRead = kernelTransaction.tokenRead();
            SchemaRead schemaRead = kernelTransaction.schemaRead();
            ArrayList<LabelNameId> labelNamesAndIds = new ArrayList<LabelNameId>();
            List labelsInUse = Iterators.stream((Iterator)TokenAccess.LABELS.inUse(kernelTransaction.dataRead(), kernelTransaction.schemaRead(), kernelTransaction.tokenRead())).toList();
            for (Label label : labelsInUse) {
                String labelName = label.name();
                int labelId = tokenRead.nodeLabel(labelName);
                if (!mode.allowsTraverseNode(new int[]{labelId})) continue;
                labelNamesAndIds.add(new LabelNameId(labelName, labelId));
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Iterator indexReferences = schemaRead.indexesGetForLabel(labelId);
                ArrayList<String> indexes = new ArrayList<String>();
                while (indexReferences.hasNext()) {
                    IndexDescriptor index = (IndexDescriptor)indexReferences.next();
                    if (index.isUnique()) continue;
                    CharSequence[] propertyNames = PropertyNameUtils.getPropertyKeys((TokenNameLookup)tokenRead, (int[])index.schema().getPropertyIds());
                    indexes.add(String.join((CharSequence)",", propertyNames));
                }
                properties.put("indexes", indexes);
                Iterator nodePropertyConstraintIterator = schemaRead.constraintsGetForLabel(labelId);
                ArrayList<String> constraints = new ArrayList<String>();
                while (nodePropertyConstraintIterator.hasNext()) {
                    ConstraintDescriptor constraint = (ConstraintDescriptor)nodePropertyConstraintIterator.next();
                    constraints.add(constraint.userDescription((TokenNameLookup)tokenRead));
                }
                properties.put("constraints", constraints);
                SchemaProcedure.getOrCreateLabel(label.name(), properties, nodes);
            }
            List relTypesInUse = Iterators.stream((Iterator)TokenAccess.RELATIONSHIP_TYPES.inUse(kernelTransaction.dataRead(), kernelTransaction.schemaRead(), kernelTransaction.tokenRead())).toList();
            for (RelationshipType relationshipType : relTypesInUse) {
                String relationshipTypeGetName = relationshipType.name();
                int relId = tokenRead.relationshipType(relationshipTypeGetName);
                if (!mode.allowsTraverseRelType(relId)) continue;
                LinkedList<VirtualNodeHack> startNodes = new LinkedList<VirtualNodeHack>();
                LinkedList<VirtualNodeHack> endNodes = new LinkedList<VirtualNodeHack>();
                for (LabelNameId labelNameAndId : labelNamesAndIds) {
                    String labelName = labelNameAndId.name();
                    int labelId = labelNameAndId.id();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    VirtualNodeHack node = SchemaProcedure.getOrCreateLabel(labelName, properties, nodes);
                    if (dataRead.countsForRelationship(labelId, relId, -1) > 0L) {
                        startNodes.add(node);
                    }
                    if (dataRead.countsForRelationship(-1, relId, labelId) <= 0L) continue;
                    endNodes.add(node);
                }
                for (VirtualNodeHack startNode : startNodes) {
                    for (VirtualNodeHack endNode : endNodes) {
                        SchemaProcedure.addRelationship(startNode, endNode, relationshipTypeGetName, relationships);
                    }
                }
            }
        }
        return SchemaProcedure.getGraphResult(nodes, relationships);
    }

    private static VirtualNodeHack getOrCreateLabel(String label, Map<String, Object> properties, Map<String, VirtualNodeHack> nodeMap) {
        if (nodeMap.containsKey(label)) {
            return nodeMap.get(label);
        }
        VirtualNodeHack node = new VirtualNodeHack(label, properties);
        nodeMap.put(label, node);
        return node;
    }

    private static void addRelationship(VirtualNodeHack startNode, VirtualNodeHack endNode, String relType, Map<String, Set<VirtualRelationshipHack>> relationshipMap) {
        Set<Object> relationshipsForType;
        if (!relationshipMap.containsKey(relType)) {
            relationshipsForType = new HashSet();
            relationshipMap.put(relType, relationshipsForType);
        } else {
            relationshipsForType = relationshipMap.get(relType);
        }
        VirtualRelationshipHack relationship = new VirtualRelationshipHack(startNode, endNode, relType);
        relationshipsForType.add(relationship);
    }

    private static GraphResult getGraphResult(Map<String, VirtualNodeHack> nodeMap, Map<String, Set<VirtualRelationshipHack>> relationshipMap) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        for (Set<VirtualRelationshipHack> relationship : relationshipMap.values()) {
            relationships.addAll(relationship);
        }
        GraphResult graphResult = new GraphResult(new ArrayList<Node>(nodeMap.values()), relationships);
        return graphResult;
    }

    private record LabelNameId(String name, int id) {
    }

    private static class VirtualNodeHack
    implements Node {
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();
        private static final AtomicLong MIN_ID = new AtomicLong(-1L);
        private final long id = MIN_ID.getAndDecrement();
        private final Label label;

        VirtualNodeHack(String label, Map<String, Object> properties) {
            this.label = Label.label((String)label);
            this.propertyMap.putAll(properties);
            this.propertyMap.put("name", label);
        }

        public long getId() {
            return this.id;
        }

        public String getElementId() {
            return String.valueOf(this.id);
        }

        public Map<String, Object> getAllProperties() {
            return this.propertyMap;
        }

        public Iterable<Label> getLabels() {
            return Collections.singletonList(this.label);
        }

        public void delete() {
        }

        public ResourceIterable<Relationship> getRelationships() {
            return null;
        }

        public boolean hasRelationship() {
            return false;
        }

        public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
            return null;
        }

        public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return null;
        }

        public ResourceIterable<Relationship> getRelationships(Direction direction) {
            return null;
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(Direction direction) {
            return false;
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return null;
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return null;
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        public int getDegree() {
            return 0;
        }

        public int getDegree(RelationshipType type) {
            return 0;
        }

        public int getDegree(RelationshipType type, Direction direction) {
            return 0;
        }

        public int getDegree(Direction direction) {
            return 0;
        }

        public void addLabel(Label label) {
        }

        public void removeLabel(Label label) {
        }

        public boolean hasLabel(Label label) {
            return false;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }

        public Object removeProperty(String key) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }

        public Map<String, Object> getProperties(String ... keys) {
            return null;
        }

        public String toString() {
            return String.format("VirtualNodeHack[%s]", this.id);
        }
    }

    public record GraphResult(List<Node> nodes, List<Relationship> relationships) {
    }

    private static class VirtualRelationshipHack
    implements Relationship {
        private static final AtomicLong MIN_ID = new AtomicLong(-1L);
        private final long id;
        private final Node startNode;
        private final Node endNode;
        private final RelationshipType relationshipType;
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();

        VirtualRelationshipHack(VirtualNodeHack startNode, VirtualNodeHack endNode, String type) {
            this.id = MIN_ID.getAndDecrement();
            this.startNode = startNode;
            this.endNode = endNode;
            this.propertyMap.put("name", type);
            this.relationshipType = () -> type;
        }

        public long getId() {
            return this.id;
        }

        public String getElementId() {
            return String.valueOf(this.id);
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public RelationshipType getType() {
            return this.relationshipType;
        }

        public Map<String, Object> getAllProperties() {
            return this.propertyMap;
        }

        public void delete() {
        }

        public Node getOtherNode(Node node) {
            return null;
        }

        public Node[] getNodes() {
            return new Node[0];
        }

        public boolean isType(RelationshipType type) {
            return false;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }

        public Object removeProperty(String key) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }

        public Map<String, Object> getProperties(String ... keys) {
            return null;
        }

        public String toString() {
            return String.format("VirtualRelationshipHack[%s]", this.id);
        }
    }
}

