/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.cypher.internal.expressions.functions.Category;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@Description(value="Construct a Duration value.")
class DurationFunction
implements CallableUserFunction {
    private static final String CATEGORY = Category.TEMPORAL();
    private static final UserFunctionSignature DURATION = new UserFunctionSignature(new QualifiedName(ArrayUtils.EMPTY_STRING_ARRAY, "duration"), Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny)), (Neo4jTypes.AnyType)Neo4jTypes.NTDuration, null, DurationFunction.class.getAnnotation(Description.class).value(), CATEGORY, true, true, false, true);

    DurationFunction() {
    }

    static void register(GlobalProcedures globalProcedures) throws ProcedureException {
        globalProcedures.register((CallableUserFunction)new DurationFunction());
        globalProcedures.register((CallableUserFunction)new Between("between"));
        globalProcedures.register((CallableUserFunction)new Between("inMonths"));
        globalProcedures.register((CallableUserFunction)new Between("inDays"));
        globalProcedures.register((CallableUserFunction)new Between("inSeconds"));
    }

    public UserFunctionSignature signature() {
        return DURATION;
    }

    public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
        if (input == null) {
            return Values.NO_VALUE;
        }
        if (input.length == 1) {
            if (input[0] == Values.NO_VALUE || input[0] == null) {
                return Values.NO_VALUE;
            }
            if (input[0] instanceof TextValue) {
                return DurationValue.parse((TextValue)((TextValue)input[0]));
            }
            AnyValue anyValue = input[0];
            if (anyValue instanceof MapValue) {
                MapValue map = (MapValue)anyValue;
                return DurationValue.build((MapValue)map);
            }
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
    }

    private static class Between
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Compute the duration between the 'from' instant (inclusive) and the 'to' instant (exclusive) in %s.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"from", (Neo4jTypes.AnyType)Neo4jTypes.NTAny), FieldSignature.inputField((String)"to", (Neo4jTypes.AnyType)Neo4jTypes.NTAny));
        private final UserFunctionSignature signature;
        private final TemporalUnit unit;

        private Between(String unit) {
            this.signature = new UserFunctionSignature(new QualifiedName(new String[]{"duration"}, unit), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDuration, null, String.format(DESCRIPTION, switch (unit) {
                case "between" -> {
                    this.unit = null;
                    yield "logical units";
                }
                case "inMonths" -> {
                    this.unit = ChronoUnit.MONTHS;
                    yield "months";
                }
                case "inDays" -> {
                    this.unit = ChronoUnit.DAYS;
                    yield "days";
                }
                case "inSeconds" -> {
                    this.unit = ChronoUnit.SECONDS;
                    yield "seconds";
                }
                default -> throw new IllegalStateException("Unsupported unit: " + unit);
            }), CATEGORY, true, true, false, true);
        }

        public UserFunctionSignature signature() {
            return this.signature;
        }

        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            AnyValue anyValue;
            if (input == null || input.length == 2 && (input[0] == Values.NO_VALUE || input[0] == null) || input[1] == Values.NO_VALUE || input[1] == null) {
                return Values.NO_VALUE;
            }
            if (input.length == 2 && (anyValue = input[0]) instanceof TemporalValue) {
                TemporalValue from = (TemporalValue)anyValue;
                anyValue = input[1];
                if (anyValue instanceof TemporalValue) {
                    TemporalValue to = (TemporalValue)anyValue;
                    return DurationValue.between((TemporalUnit)this.unit, (Temporal)from, (Temporal)to);
                }
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input), new Object[0]);
        }
    }
}

