/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.ClientSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.ParameterNames;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.procedure.builtin.routing.RoutingResultFormat;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureHelpers;
import org.neo4j.procedure.builtin.routing.RoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.ServerSideRoutingTableProvider;
import org.neo4j.procedure.builtin.routing.SingleAddressRoutingTableProvider;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class GetRoutingTableProcedure
implements CallableProcedure {
    private static final String NAME = "getRoutingTable";
    public static final String ADDRESS_CONTEXT_KEY = "address";
    public static final String FROM_ALIAS_KEY = "alias";
    private final ProcedureSignature signature;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final Log log;
    private final RoutingTableProcedureValidator validator;
    private final ClientSideRoutingTableProvider clientSideRoutingTableProvider;
    private final ServerSideRoutingTableProvider serverSideRoutingTableProvider;
    private final ClientRoutingDomainChecker clientRoutingDomainChecker;
    private final Supplier<GraphDatabaseSettings.RoutingMode> defaultRouterSupplier;
    private final Supplier<Boolean> boltEnabled;
    private final boolean logInfoRoutingTableResult;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final boolean clientProvidedRouterEnabled;
    private final List<String> clientProvidedRouterPrefixes;
    private final Duration clientProvidedRouterPrefixRotationPeriod;
    private final String clientProvidedRouterSuffix;
    private final Clock clock;

    public GetRoutingTableProcedure(List<String> namespace, String description, DatabaseReferenceRepository databaseReferenceRepo, RoutingTableProcedureValidator validator, SingleAddressRoutingTableProvider routingTableProvider, ClientRoutingDomainChecker clientRoutingDomainChecker, Config config, LogProvider logProvider, DefaultDatabaseResolver defaultDatabaseResolver, Clock clock) {
        this(namespace, description, databaseReferenceRepo, validator, routingTableProvider, routingTableProvider, clientRoutingDomainChecker, config, logProvider, defaultDatabaseResolver, clock);
    }

    public GetRoutingTableProcedure(List<String> namespace, String description, DatabaseReferenceRepository databaseReferenceRepo, RoutingTableProcedureValidator validator, ClientSideRoutingTableProvider clientSideRoutingTableProvider, ServerSideRoutingTableProvider serverSideRoutingTableProvider, ClientRoutingDomainChecker clientRoutingDomainChecker, Config config, LogProvider logProvider, DefaultDatabaseResolver defaultDatabaseResolver, Clock clock) {
        this.signature = GetRoutingTableProcedure.buildSignature(namespace, description);
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.log = logProvider.getLog(this.getClass());
        this.validator = validator;
        this.clientSideRoutingTableProvider = clientSideRoutingTableProvider;
        this.serverSideRoutingTableProvider = serverSideRoutingTableProvider;
        this.clientRoutingDomainChecker = clientRoutingDomainChecker;
        this.defaultRouterSupplier = () -> (GraphDatabaseSettings.RoutingMode)config.get(GraphDatabaseSettings.routing_default_router);
        this.boltEnabled = () -> (Boolean)config.get(BoltConnector.enabled);
        this.logInfoRoutingTableResult = (Boolean)config.get(GraphDatabaseInternalSettings.pagecache_warmup_blocking);
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.clientProvidedRouterEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.client_provided_router_enabled);
        this.clientProvidedRouterPrefixes = (List)config.get(GraphDatabaseInternalSettings.client_provided_router_prefixes);
        this.clientProvidedRouterSuffix = (String)config.get(GraphDatabaseInternalSettings.client_provided_router_suffix);
        this.clientProvidedRouterPrefixRotationPeriod = (Duration)config.get(GraphDatabaseInternalSettings.client_provided_router_prefix_rotation_period);
        this.clock = clock;
    }

    public ProcedureSignature signature() {
        return this.signature;
    }

    public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        String user = ctx.securityContext().subject().executingUser();
        DatabaseReference databaseReference = this.extractDatabaseReference(input, user);
        MapValue routingContext = GetRoutingTableProcedure.extractRoutingContext(input);
        this.assertBoltConnectorEnabled(databaseReference);
        this.assertNotIllegalAliasChain(databaseReference, routingContext);
        try {
            RoutingResult result = this.invoke(databaseReference, routingContext);
            if (this.logInfoRoutingTableResult) {
                this.log.info("Routing result for database %s and routing context %s is %s", new Object[]{databaseReference, routingContext, result});
            } else {
                this.log.debug("Routing result for database %s and routing context %s is %s", new Object[]{databaseReference, routingContext, result});
            }
            GetRoutingTableProcedure.assertRoutingResultNotEmpty(result, databaseReference);
            return RawIterator.of((Object[])new AnyValue[][]{RoutingResultFormat.build(result)});
        }
        catch (ProcedureException ex) {
            this.assertDatabaseExists(databaseReference);
            throw ex;
        }
    }

    private RoutingResult invoke(DatabaseReference databaseReference, MapValue routingContext) throws ProcedureException {
        boolean shouldReplaceRouter;
        RoutingResult result;
        Optional<SocketAddress> clientProvidedAddress = RoutingTableProcedureHelpers.findClientProvidedAddress(routingContext, 7687, this.log);
        boolean isInternalRef = databaseReference instanceof DatabaseReference.Internal;
        if (!isInternalRef) {
            result = this.serverSideRoutingTableProvider.getServerSideRoutingTable(clientProvidedAddress);
        } else if (this.configAllowsForClientSideRouting(this.defaultRouterSupplier.get(), clientProvidedAddress)) {
            this.validator.isValidForClientSideRouting((DatabaseReference.Internal)databaseReference);
            result = this.clientSideRoutingTableProvider.getRoutingResultForClientSideRouting((DatabaseReference.Internal)databaseReference, routingContext);
        } else {
            this.validator.isValidForServerSideRouting((DatabaseReference.Internal)databaseReference);
            result = this.serverSideRoutingTableProvider.getServerSideRoutingTable(clientProvidedAddress);
        }
        Boolean validClientProvidedRouterExists = clientProvidedAddress.map(a -> a.getHostname().endsWith(this.clientProvidedRouterSuffix)).orElse(false);
        boolean bl = shouldReplaceRouter = this.clientProvidedRouterEnabled && validClientProvidedRouterExists != false;
        if (shouldReplaceRouter) {
            result = this.replaceRouterWithClientProvidedAddress(result, clientProvidedAddress.get());
        }
        return result;
    }

    private DatabaseReference extractDatabaseReference(AnyValue[] input, String user) throws ProcedureException {
        String databaseName;
        AnyValue arg = input[1];
        if (arg == Values.NO_VALUE) {
            databaseName = this.defaultDatabaseResolver.defaultDatabase(user);
        } else if (arg instanceof TextValue) {
            databaseName = ((TextValue)arg).stringValue();
        } else {
            throw new IllegalArgumentException("Illegal database name argument " + String.valueOf(arg));
        }
        return (DatabaseReference)this.databaseReferenceRepo.getByName(databaseName).orElseThrow(() -> RoutingTableProcedureHelpers.databaseNotFoundException(databaseName));
    }

    private static MapValue extractRoutingContext(AnyValue[] input) {
        AnyValue arg = input[0];
        if (arg == Values.NO_VALUE) {
            return MapValue.EMPTY;
        }
        if (arg instanceof MapValue) {
            return (MapValue)arg;
        }
        throw new IllegalArgumentException("Illegal routing context argument " + String.valueOf(arg));
    }

    private static ProcedureSignature buildSignature(List<String> namespace, String description) {
        return ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(namespace, NAME)).in(ParameterNames.CONTEXT.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTMap).in(ParameterNames.DATABASE.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTString, DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.SERVERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).mode(Mode.DBMS).description(description).systemProcedure().allowExpiredCredentials().build();
    }

    private boolean configAllowsForClientSideRouting(GraphDatabaseSettings.RoutingMode defaultRouter, Optional<SocketAddress> clientProvidedAddress) {
        switch (defaultRouter) {
            case CLIENT: {
                return true;
            }
            case SERVER: {
                return clientProvidedAddress.isEmpty() || this.clientRoutingDomainChecker.shouldGetClientRouting(clientProvidedAddress.get());
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(defaultRouter));
    }

    private void assertBoltConnectorEnabled(DatabaseReference databaseReference) throws ProcedureException {
        if (!this.boltEnabled.get().booleanValue()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Cannot get routing table for " + String.valueOf(databaseReference.alias()) + " because Bolt is not enabled. Please update your configuration for '" + BoltConnector.enabled.name() + "'", new Object[0]);
        }
    }

    private static void assertRoutingResultNotEmpty(RoutingResult result, DatabaseReference databaseReference) throws ProcedureException {
        if (result.containsNoEndpoints()) {
            throw new ProcedureException((Status)Status.Database.DatabaseUnavailable, "Routing table for database " + String.valueOf(databaseReference.alias()) + " is empty", new Object[0]);
        }
    }

    private void assertDatabaseExists(DatabaseReference databaseReference) throws ProcedureException {
        this.databaseReferenceRepo.getByName(databaseReference.alias()).orElseThrow(() -> RoutingTableProcedureHelpers.databaseNotFoundException(databaseReference.alias().name()));
    }

    private void assertNotIllegalAliasChain(DatabaseReference databaseReference, MapValue routingContext) throws ProcedureException {
        boolean sourceAliasIsPresent;
        boolean refIsRemoteAlias = databaseReference instanceof DatabaseReference.External;
        AnyValue sourceAlias = routingContext.get(FROM_ALIAS_KEY);
        boolean bl = sourceAliasIsPresent = sourceAlias != null && sourceAlias != Values.NO_VALUE;
        if (refIsRemoteAlias && sourceAliasIsPresent) {
            String sourceAliasString = ((TextValue)sourceAlias).stringValue();
            throw new ProcedureException((Status)Status.Database.IllegalAliasChain, "Unable to provide a routing table for the database '" + databaseReference.alias().name() + "' because the request came from another alias '" + sourceAliasString + "' and alias chains are not permitted.", new Object[0]);
        }
    }

    private RoutingResult replaceRouterWithClientProvidedAddress(RoutingResult oldResult, SocketAddress clientProvidedAddress) {
        long millisSinceEpoch = this.clock.instant().toEpochMilli();
        String prefix = GetRoutingTableProcedure.calculateClientProvidedRouterPrefix(this.clientProvidedRouterPrefixes, this.clientProvidedRouterPrefixRotationPeriod.toMillis(), millisSinceEpoch);
        return new RoutingResult(List.of(new SocketAddress(String.format("%s-%s", prefix, clientProvidedAddress.getHostname()), clientProvidedAddress.getPort())), oldResult.writeEndpoints(), oldResult.readEndpoints(), oldResult.ttlMillis());
    }

    public static String calculateClientProvidedRouterPrefix(List<String> prefixes, long rotationPeriodMills, long millisSinceEpoch) {
        long periodsSinceEpoch = millisSinceEpoch / rotationPeriodMills;
        int prefixToSelect = (int)(periodsSinceEpoch % (long)prefixes.size());
        return prefixes.get(prefixToSelect);
    }
}

