/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.ConstraintsProcedureUtil;
import org.neo4j.procedure.builtin.IndexProcedures;
import org.neo4j.procedure.builtin.NodePropertySchemaInfoResult;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.RelationshipPropertySchemaInfoResult;
import org.neo4j.procedure.builtin.SchemaCalculator;
import org.neo4j.procedure.builtin.SchemaProcedure;
import org.neo4j.procedure.builtin.SchemaStatementProcedure;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;
import org.neo4j.values.storable.Value;

public class BuiltInProcedures {
    private static final int NOT_EXISTING_INDEX_ID = -1;
    static final long LONG_FIELD_NOT_CALCULATED = -1L;
    @Context
    public KernelTransaction kernelTransaction;
    @Context
    public Transaction transaction;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graphDatabaseAPI;
    @Context
    public ProcedureCallContext callContext;

    @SystemProcedure
    @Description(value="Provides information regarding the database.")
    @Procedure(name="db.info", mode=Mode.READ)
    public Stream<DatabaseInfo> databaseInfo() throws NoSuchAlgorithmException {
        StoreIdProvider storeIdProvider = (StoreIdProvider)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(StoreIdProvider.class);
        String creationTime = ProceduresTimeFormatHelper.formatTime(storeIdProvider.getStoreId().getCreationTime(), this.getConfiguredTimeZone());
        return Stream.of(new DatabaseInfo(StoreIdDecodeUtils.decodeId((StoreIdProvider)storeIdProvider), this.graphDatabaseAPI.databaseName(), creationTime));
    }

    @SystemProcedure
    @Description(value="List all available labels in the database.")
    @Procedure(name="db.labels", mode=Mode.READ)
    public Stream<LabelResult> listLabels() {
        List labelsInUse;
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        AccessMode mode = this.kernelTransaction.securityContext().mode();
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        try (KernelTransaction.Revertable ignore = this.kernelTransaction.overrideWith(SecurityContext.AUTH_DISABLED);){
            labelsInUse = Iterators.stream((Iterator)TokenAccess.LABELS.inUse(this.kernelTransaction)).filter(label -> mode.allowsTraverseNode(new long[]{tokenRead.nodeLabel(label.name())})).map(x$0 -> new LabelResult((Label)x$0)).collect(Collectors.toList());
        }
        return labelsInUse.stream();
    }

    @SystemProcedure
    @Description(value="List all property keys in the database.")
    @Procedure(name="db.propertyKeys", mode=Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        List propertyKeys = Iterators.stream((Iterator)TokenAccess.PROPERTY_KEYS.all(this.kernelTransaction)).map(x$0 -> new PropertyKeyResult((String)x$0)).collect(Collectors.toList());
        return propertyKeys.stream();
    }

    @SystemProcedure
    @Description(value="List all available relationship types in the database.")
    @Procedure(name="db.relationshipTypes", mode=Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        List relTypesInUse;
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        AccessMode mode = this.kernelTransaction.securityContext().mode();
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        try (KernelTransaction.Revertable ignore = this.kernelTransaction.overrideWith(SecurityContext.AUTH_DISABLED);){
            relTypesInUse = Iterators.stream((Iterator)TokenAccess.RELATIONSHIP_TYPES.inUse(this.kernelTransaction)).filter(type -> mode.allowsTraverseRelType(tokenRead.relationshipType(type.name()))).map(x$0 -> new RelationshipTypeResult((RelationshipType)x$0)).collect(Collectors.toList());
        }
        return relTypesInUse.stream();
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @SystemProcedure
    @Description(value="List all indexes in the database.")
    @Procedure(name="db.indexes", mode=Mode.READ, deprecatedBy="SHOW INDEXES command")
    public Stream<IndexResult> listIndexes() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        IndexingService indexingService = (IndexingService)this.resolver.resolveDependency(IndexingService.class);
        SchemaReadCore schemaRead = this.kernelTransaction.schemaRead().snapshot();
        List indexes = Iterators.asList((Iterator)schemaRead.indexesGetAll());
        ArrayList<IndexResult> result = new ArrayList<IndexResult>();
        for (IndexDescriptor index : indexes) {
            IndexResult indexResult = BuiltInProcedures.asIndexResult((TokenNameLookup)tokenRead, schemaRead, index);
            result.add(indexResult);
        }
        result.sort(Comparator.comparing(r -> r.name));
        return result.stream();
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @SystemProcedure
    @Description(value="Detailed description of specific index.")
    @Procedure(name="db.indexDetails", mode=Mode.READ, deprecatedBy="SHOW INDEXES YIELD * command")
    public Stream<IndexDetailResult> indexDetails(@Name(value="indexName") String indexName) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        IndexingService indexingService = (IndexingService)this.resolver.resolveDependency(IndexingService.class);
        SchemaReadCore schemaRead = this.kernelTransaction.schemaRead().snapshot();
        List indexes = Iterators.asList((Iterator)schemaRead.indexesGetAll());
        IndexDescriptor index = null;
        for (IndexDescriptor candidate : indexes) {
            if (!candidate.getName().equals(indexName)) continue;
            index = candidate;
            break;
        }
        if (index == null) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, "Could not find index with name \"" + indexName + "\"", new Object[0]);
        }
        IndexDetailResult indexDetailResult = BuiltInProcedures.asIndexDetails((TokenNameLookup)tokenRead, schemaRead, index);
        return Stream.of(indexDetailResult);
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @SystemProcedure
    @Description(value="List all statements for creating and dropping existing indexes and constraints. Note that only index types introduced before Neo4j 4.3 are included.")
    @Procedure(name="db.schemaStatements", mode=Mode.READ, deprecatedBy="SHOW INDEXES YIELD * command and SHOW CONSTRAINTS YIELD * command")
    public Stream<SchemaStatementResult> schemaStatements() throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        SchemaReadCore schemaRead = this.kernelTransaction.schemaRead().snapshot();
        TokenRead tokenRead = this.kernelTransaction.tokenRead();
        return SchemaStatementProcedure.createSchemaStatementResults(schemaRead, tokenRead).stream();
    }

    private static IndexResult asIndexResult(TokenNameLookup tokenLookup, SchemaReadCore schemaRead, IndexDescriptor index) {
        SchemaDescriptor schema = index.schema();
        long id = index.getId();
        String name = index.getName();
        IndexStatus status = BuiltInProcedures.getIndexStatus(schemaRead, index);
        String uniqueness = IndexUniqueness.getUniquenessOf(index);
        String type = index.getIndexType().name();
        String entityType = index.schema().entityType().name();
        List<String> labelsOrTypes = Arrays.asList(tokenLookup.entityTokensGetNames(schema.entityType(), schema.getEntityTokenIds()));
        List<String> properties = BuiltInProcedures.propertyNames(tokenLookup, index);
        String provider = index.getIndexProvider().name();
        return new IndexResult(id, name, status.state, status.populationProgress, uniqueness, type, entityType, labelsOrTypes, properties, provider);
    }

    private static IndexDetailResult asIndexDetails(TokenNameLookup tokenLookup, SchemaReadCore schemaRead, IndexDescriptor index) {
        long id = index.getId();
        String name = index.getName();
        IndexStatus status = BuiltInProcedures.getIndexStatus(schemaRead, index);
        String uniqueness = IndexUniqueness.getUniquenessOf(index);
        String type = index.getIndexType().name();
        String entityType = index.schema().entityType().name();
        SchemaDescriptor schema = index.schema();
        List<String> labelsOrTypes = Arrays.asList(tokenLookup.entityTokensGetNames(schema.entityType(), schema.getEntityTokenIds()));
        List<String> properties = BuiltInProcedures.propertyNames(tokenLookup, index);
        String provider = index.getIndexProvider().name();
        Map<String, Object> indexConfig = BuiltInProcedures.asObjectMap(index.getIndexConfig().asMap());
        return new IndexDetailResult(id, name, status.state, status.populationProgress, uniqueness, type, entityType, labelsOrTypes, properties, provider, indexConfig, status.failureMessage);
    }

    private static IndexStatus getIndexStatus(SchemaReadCore schemaRead, IndexDescriptor index) {
        IndexStatus status = new IndexStatus();
        try {
            InternalIndexState internalIndexState = schemaRead.indexGetState(index);
            status.state = internalIndexState.toString();
            PopulationProgress progress = schemaRead.indexGetPopulationProgress(index);
            status.populationProgress = progress.toIndexPopulationProgress().getCompletedPercentage();
            status.failureMessage = internalIndexState == InternalIndexState.FAILED ? schemaRead.indexGetFailure(index) : "";
        }
        catch (IndexNotFoundKernelException e) {
            status.state = "NOT FOUND";
            status.populationProgress = 0.0;
            status.failureMessage = "Index not found. It might have been concurrently dropped.";
        }
        return status;
    }

    private static Map<String, Object> asObjectMap(Map<String, Value> valueConfig) {
        HashMap<String, Object> objectConfig = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : valueConfig.entrySet()) {
            objectConfig.put(entry.getKey(), entry.getValue().asObject());
        }
        return objectConfig;
    }

    @SystemProcedure
    @Description(value="Wait for an index to come online (for example: CALL db.awaitIndex(\"MyIndex\", 300)).")
    @Procedure(name="db.awaitIndex", mode=Mode.READ)
    public void awaitIndex(@Name(value="indexName") String indexName, @Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.awaitIndexByName(indexName, timeout, TimeUnit.SECONDS);
    }

    @SystemProcedure
    @Description(value="Wait for all indexes to come online (for example: CALL db.awaitIndexes(300)).")
    @Procedure(name="db.awaitIndexes", mode=Mode.READ)
    public void awaitIndexes(@Name(value="timeOutSeconds", defaultValue="300") long timeout) {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        this.transaction.schema().awaitIndexesOnline(timeout, TimeUnit.SECONDS);
    }

    @SystemProcedure
    @Description(value="Schedule resampling of an index (for example: CALL db.resampleIndex(\"MyIndex\")).")
    @Procedure(name="db.resampleIndex", mode=Mode.READ)
    public void resampleIndex(@Name(value="indexName") String indexName) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleIndex(indexName);
    }

    @SystemProcedure
    @Description(value="Schedule resampling of all outdated indexes.")
    @Procedure(name="db.resampleOutdatedIndexes", mode=Mode.READ)
    public void resampleOutdatedIndexes() {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleOutdatedIndexes();
    }

    @Admin
    @SystemProcedure
    @Description(value="Triggers an index resample and waits for it to complete, and after that clears query caches. After this procedure has finished queries will be planned using the latest database statistics.")
    @Procedure(name="db.prepareForReplanning", mode=Mode.READ)
    public void prepareForReplanning(@Name(value="timeOutSeconds", defaultValue="300") long timeOutSeconds) throws ProcedureException {
        if (this.callContext.isSystemDatabase()) {
            return;
        }
        IndexProcedures indexProcedures = this.indexProcedures();
        indexProcedures.resampleOutdatedIndexes(timeOutSeconds);
        ((QueryExecutionEngine)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(QueryExecutionEngine.class)).clearQueryCaches();
    }

    @SystemProcedure
    @Procedure(name="db.schema.nodeTypeProperties", mode=Mode.READ)
    @Description(value="Show the derived property schema of the nodes in tabular form.")
    public Stream<NodePropertySchemaInfoResult> nodePropertySchema() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new SchemaCalculator(this.kernelTransaction).calculateTabularResultStreamForNodes();
    }

    @SystemProcedure
    @Procedure(name="db.schema.relTypeProperties", mode=Mode.READ)
    @Description(value="Show the derived property schema of the relationships in tabular form.")
    public Stream<RelationshipPropertySchemaInfoResult> relationshipPropertySchema() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return new SchemaCalculator(this.kernelTransaction).calculateTabularResultStreamForRels();
    }

    @SystemProcedure
    @Description(value="Visualizes the schema of the data based on available statistics. A new node is returned for each label. The properties represented on the node include: `name` (label name), `indexes` (list of indexes), and `constraints` (list of constraints). A relationship of a given type is returned for all possible combinations of start and end nodes. Note that this may include additional relationships that do not exist in the data due to the information available in the count store. ")
    @Procedure(name="db.schema.visualization", mode=Mode.READ)
    public Stream<SchemaProcedure.GraphResult> schemaVisualization() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        return Stream.of(new SchemaProcedure((InternalTransaction)this.transaction).buildSchemaGraph());
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @SystemProcedure
    @Description(value="List all constraints in the database.")
    @Procedure(name="db.constraints", mode=Mode.READ, deprecatedBy="SHOW CONSTRAINTS command")
    public Stream<ConstraintResult> listConstraints() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        SchemaReadCore schemaRead = this.kernelTransaction.schemaRead().snapshot();
        ArrayList<ConstraintResult> result = new ArrayList<ConstraintResult>();
        List constraintDescriptors = Iterators.asList((Iterator)schemaRead.constraintsGetAll());
        for (ConstraintDescriptor constraint : constraintDescriptors) {
            String description = ConstraintsProcedureUtil.prettyPrint(constraint, (TokenNameLookup)this.kernelTransaction.tokenRead());
            String details = constraint.userDescription((TokenNameLookup)this.kernelTransaction.tokenRead());
            result.add(new ConstraintResult(constraint.getName(), description, details));
        }
        result.sort(Comparator.comparing(r -> r.name));
        return result.stream();
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="Create a named schema index with specified index provider and configuration (optional). Yield: name, labels, properties, providerName, status")
    @Procedure(name="db.createIndex", mode=Mode.SCHEMA, deprecatedBy="CREATE INDEX command")
    public Stream<SchemaIndexInfo> createIndex(@Name(value="indexName") String indexName, @Name(value="labels") List<String> labels, @Name(value="properties") List<String> properties, @Name(value="providerName") String providerName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws ProcedureException {
        IndexProcedures indexProcedures = this.indexProcedures();
        IndexProviderDescriptor indexProviderDescriptor = this.getIndexProviderDescriptor(providerName);
        return indexProcedures.createIndex(indexName, labels, properties, indexProviderDescriptor, config);
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="Create a named unique property constraint. Backing index will use specified index provider and configuration (optional). Yield: name, labels, properties, providerName, status")
    @Procedure(name="db.createUniquePropertyConstraint", mode=Mode.SCHEMA, deprecatedBy="CREATE CONSTRAINT ... IS UNIQUE command")
    public Stream<SchemaIndexInfo> createUniquePropertyConstraint(@Name(value="constraintName") String constraintName, @Name(value="labels") List<String> labels, @Name(value="properties") List<String> properties, @Name(value="providerName") String providerName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws ProcedureException {
        IndexProcedures indexProcedures = this.indexProcedures();
        IndexProviderDescriptor indexProviderDescriptor = this.getIndexProviderDescriptor(providerName);
        return indexProcedures.createUniquePropertyConstraint(constraintName, labels, properties, indexProviderDescriptor, config);
    }

    @SystemProcedure(allowExpiredCredentials=true)
    @Procedure(name="db.ping", mode=Mode.READ)
    @Description(value="This procedure can be used by client side tooling to test whether they are correctly connected to a database. The procedure is available in all databases and always returns true. A faulty connection can be detected by not being able to call this procedure.")
    public Stream<BooleanResult> ping() {
        return Stream.of(new BooleanResult(Boolean.TRUE));
    }

    private static List<String> propertyNames(TokenNameLookup tokens, IndexDescriptor index) {
        int[] propertyIds = index.schema().getPropertyIds();
        ArrayList<String> propertyNames = new ArrayList<String>(propertyIds.length);
        for (int propertyId : propertyIds) {
            propertyNames.add(tokens.propertyKeyGetName(propertyId));
        }
        return propertyNames;
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.resolver.resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    private IndexProcedures indexProcedures() {
        return new IndexProcedures(this.kernelTransaction, (IndexingService)this.resolver.resolveDependency(IndexingService.class));
    }

    private IndexProviderDescriptor getIndexProviderDescriptor(String providerName) {
        return ((IndexingService)this.resolver.resolveDependency(IndexingService.class)).indexProviderByName(providerName);
    }

    private static enum IndexUniqueness {
        UNIQUE,
        NONUNIQUE;


        private static String getUniquenessOf(IndexDescriptor index) {
            return index.isUnique() ? UNIQUE.name() : NONUNIQUE.name();
        }
    }

    public static class RelationshipResult {
        public final Relationship relationship;

        public RelationshipResult(Relationship relationship) {
            this.relationship = relationship;
        }
    }

    public static class WeightedRelationshipResult {
        public final Relationship relationship;
        public final double weight;

        public WeightedRelationshipResult(Relationship relationship, double weight) {
            this.relationship = relationship;
            this.weight = weight;
        }
    }

    public static class WeightedNodeResult {
        public final Node node;
        public final double weight;

        public WeightedNodeResult(Node node, double weight) {
            this.node = node;
            this.weight = weight;
        }
    }

    public static class NodeResult {
        public final Node node;

        public NodeResult(Node node) {
            this.node = node;
        }
    }

    public static class ConstraintResult {
        public final String name;
        public final String description;
        public final String details;

        private ConstraintResult(String name, String description, String details) {
            this.name = name;
            this.description = description;
            this.details = details;
        }
    }

    public static class SchemaIndexInfo {
        public final String name;
        public final List<String> labels;
        public final List<String> properties;
        public final String providerName;
        public final String status;

        public SchemaIndexInfo(String name, List<String> labels, List<String> properties, String providerName, String status) {
            this.name = name;
            this.labels = labels;
            this.properties = properties;
            this.providerName = providerName;
            this.status = status;
        }
    }

    public static class SchemaStatementResult {
        public final String name;
        public final String type;
        public final String createStatement;
        public final String dropStatement;

        public SchemaStatementResult(String name, String type, String createStatement, String dropStatement) {
            this.name = name;
            this.type = type;
            this.createStatement = createStatement;
            this.dropStatement = dropStatement;
        }
    }

    public static class IndexDetailResult {
        public final long id;
        public final String name;
        public final String state;
        public final double populationPercent;
        public final String uniqueness;
        public final String type;
        public final String entityType;
        public final List<String> labelsOrTypes;
        public final List<String> properties;
        public final String provider;
        public final Map<String, Object> indexConfig;
        public final String failureMessage;

        private IndexDetailResult(long id, String name, String state, double populationPercent, String uniqueness, String type, String entityType, List<String> labelsOrTypes, List<String> properties, String provider, Map<String, Object> indexConfig, String failureMessage) {
            this.id = id;
            this.name = name;
            this.state = state;
            this.populationPercent = populationPercent;
            this.uniqueness = uniqueness;
            this.type = type;
            this.entityType = entityType;
            this.labelsOrTypes = labelsOrTypes;
            this.properties = properties;
            this.provider = provider;
            this.indexConfig = indexConfig;
            this.failureMessage = failureMessage;
        }

        private IndexDetailResult(IndexResult indexResult, Map<String, Object> indexConfig, String failureMessage) {
            this(indexResult.id, indexResult.name, indexResult.state, indexResult.populationPercent, indexResult.uniqueness, indexResult.type, indexResult.entityType, indexResult.labelsOrTypes, indexResult.properties, indexResult.provider, indexConfig, failureMessage);
        }
    }

    public static class IndexResult {
        public final long id;
        public final String name;
        public final String state;
        public final double populationPercent;
        public final String uniqueness;
        public final String type;
        public final String entityType;
        public final List<String> labelsOrTypes;
        public final List<String> properties;
        public final String provider;

        private IndexResult(long id, String name, String state, double populationPercent, String uniqueness, String type, String entityType, List<String> labelsOrTypes, List<String> properties, String provider) {
            this.id = id;
            this.name = name;
            this.state = state;
            this.populationPercent = populationPercent;
            this.uniqueness = uniqueness;
            this.type = type;
            this.entityType = entityType;
            this.labelsOrTypes = labelsOrTypes;
            this.properties = properties;
            this.provider = provider;
        }
    }

    public static class BooleanResult {
        public final Boolean success;

        public BooleanResult(Boolean success) {
            this.success = success;
        }
    }

    public static class RelationshipTypeResult {
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public static class DatabaseInfo {
        public final String id;
        public final String name;
        public final String creationDate;

        public DatabaseInfo(String id, String name, String creationDate) {
            this.id = id;
            this.name = name;
            this.creationDate = creationDate;
        }
    }

    public static class PropertyKeyResult {
        public final String propertyKey;

        private PropertyKeyResult(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public static class LabelResult {
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }

    private static class IndexStatus {
        String state;
        String failureMessage;
        double populationProgress;

        private IndexStatus() {
        }
    }
}

