/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TokenProcedures {
    @Context
    public KernelTransaction tx;

    @Description(value="Create a label")
    @Procedure(name="db.createLabel", mode=Mode.WRITE)
    public void createLabel(@Name(value="newLabel") String newLabel) throws KernelException {
        this.tx.tokenWrite().labelGetOrCreateForName(newLabel);
    }

    @Description(value="Create a RelationshipType")
    @Procedure(name="db.createRelationshipType", mode=Mode.WRITE)
    public void createRelationshipType(@Name(value="newRelationshipType") String newRelationshipType) throws KernelException {
        this.tx.tokenWrite().relationshipTypeGetOrCreateForName(newRelationshipType);
    }

    @Description(value="Create a Property")
    @Procedure(name="db.createProperty", mode=Mode.WRITE)
    public void createProperty(@Name(value="newProperty") String newProperty) throws KernelException {
        this.tx.tokenWrite().propertyKeyGetOrCreateForName(newProperty);
    }
}

