/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.builtin.SpecialBuiltInProcedures;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.ProcedureCompiler;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureJarLoader;
import org.neo4j.procedure.impl.ProcedureRegistry;
import org.neo4j.procedure.impl.TypeCheckers;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;

public class GlobalProceduresRegistry
extends LifecycleAdapter
implements GlobalProcedures {
    private final ProcedureRegistry registry = new ProcedureRegistry();
    private final TypeCheckers typeCheckers;
    private final ComponentRegistry safeComponents = new ComponentRegistry();
    private final ComponentRegistry allComponents = new ComponentRegistry();
    private final ProcedureCompiler compiler;
    private final ThrowingConsumer<GlobalProceduresRegistry, ProcedureException> builtin;
    private final Path proceduresDirectory;
    private final Log log;

    @VisibleForTesting
    public GlobalProceduresRegistry() {
        this(new SpecialBuiltInProcedures("N/A", "N/A"), null, (Log)NullLog.getInstance(), ProcedureConfig.DEFAULT);
    }

    public GlobalProceduresRegistry(ThrowingConsumer<GlobalProceduresRegistry, ProcedureException> builtin, Path proceduresDirectory, Log log, ProcedureConfig config) {
        this.builtin = builtin;
        this.proceduresDirectory = proceduresDirectory;
        this.log = log;
        this.typeCheckers = new TypeCheckers();
        this.compiler = new ProcedureCompiler(this.typeCheckers, this.safeComponents, this.allComponents, log, config);
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.register(proc, false);
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        this.register(function, false);
    }

    public void register(CallableUserFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation, false);
    }

    public void registerBuiltIn(CallableUserFunction function) throws ProcedureException {
        this.registry.register(function, false, true);
    }

    public void register(CallableUserAggregationFunction function, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(function, overrideCurrentImplementation, false);
    }

    public void register(CallableProcedure proc, boolean overrideCurrentImplementation) throws ProcedureException {
        this.registry.register(proc, overrideCurrentImplementation);
    }

    public void registerProcedure(Class<?> proc) throws KernelException {
        this.registerProcedure(proc, false);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation) throws KernelException {
        this.registerProcedure(proc, overrideCurrentImplementation, null);
    }

    public void registerProcedure(Class<?> proc, boolean overrideCurrentImplementation, String warning) throws KernelException {
        for (CallableProcedure procedure : this.compiler.compileProcedure(proc, warning, true)) {
            this.register(procedure, overrideCurrentImplementation);
        }
    }

    public void registerBuiltInFunctions(Class<?> func) throws KernelException {
        for (CallableUserFunction function : this.compiler.withoutNamingRestrictions().compileFunction(func, true)) {
            this.register(function, false);
        }
    }

    public void registerFunction(Class<?> func) throws KernelException {
        this.registerFunction(func, false);
    }

    public void registerAggregationFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserAggregationFunction function : this.compiler.compileAggregationFunction(func)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerAggregationFunction(Class<?> func) throws KernelException {
        this.registerAggregationFunction(func, false);
    }

    public void registerFunction(Class<?> func, boolean overrideCurrentImplementation) throws KernelException {
        for (CallableUserFunction function : this.compiler.compileFunction(func, false)) {
            this.register(function, overrideCurrentImplementation);
        }
    }

    public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
        this.typeCheckers.registerType(javaClass, new TypeCheckers.DefaultValueConverter(type));
    }

    public <T> void registerComponent(Class<T> cls, ThrowingFunction<Context, T, ProcedureException> provider, boolean safe) {
        if (safe) {
            this.safeComponents.register(cls, provider);
        }
        this.allComponents.register(cls, provider);
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
        ComponentRegistry registry = safe ? this.safeComponents : this.allComponents;
        return registry.providerFor(cls);
    }

    public ProcedureHandle procedure(QualifiedName name) throws ProcedureException {
        return this.registry.procedure(name);
    }

    public UserFunctionHandle function(QualifiedName name) {
        return this.registry.function(name);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name) {
        return this.registry.aggregationFunction(name);
    }

    public int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        return this.registry.getIdsOfFunctionsMatching(predicate);
    }

    public int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        return this.registry.getIdsOfAggregatingFunctionsMatching(predicate);
    }

    public Set<ProcedureSignature> getAllProcedures() {
        return this.registry.getAllProcedures();
    }

    public int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        return this.registry.getIdsOfProceduresMatching(predicate);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
        return this.registry.getAllNonAggregatingFunctions();
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
        return this.registry.getAllAggregatingFunctions();
    }

    public RawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        return this.registry.callProcedure(ctx, id, input, resourceTracker);
    }

    public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
        return this.registry.callFunction(ctx, id, input);
    }

    public UserAggregator createAggregationFunction(Context ctx, int id) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, id);
    }

    public void start() throws Exception {
        ProcedureJarLoader loader = new ProcedureJarLoader(this.compiler, this.log);
        ProcedureJarLoader.Callables callables = loader.loadProceduresFromDir(this.proceduresDirectory);
        for (CallableProcedure callableProcedure : callables.procedures()) {
            this.register(callableProcedure);
        }
        for (CallableUserFunction callableUserFunction : callables.functions()) {
            this.register(callableUserFunction);
        }
        for (CallableUserAggregationFunction callableUserAggregationFunction : callables.aggregationFunctions()) {
            this.register(callableUserAggregationFunction);
        }
        this.builtin.accept((Object)this);
    }
}

