/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a Date instant.")
class DateFunction
extends TemporalFunction<DateValue> {
    DateFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDate, defaultZone);
    }

    @Override
    protected DateValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateValue.now((Clock)clock, defaultZone) : DateValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateValue.parse((TextValue)value);
    }

    @Override
    protected DateValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected DateValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

