/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.QueryId;
import org.neo4j.procedure.builtin.TransactionDependenciesResolver;
import org.neo4j.procedure.builtin.TransactionId;

public class TransactionStatusResult {
    private static final String RUNNING_STATE = "Running";
    private static final String CLOSING_STATE = "Closing";
    private static final String BLOCKED_STATE = "Blocked by: ";
    private static final String TERMINATED_STATE = "Terminated with reason: %s";
    public final String transactionId;
    public final String username;
    public final Map<String, Object> metaData;
    public final String startTime;
    public final String protocol;
    public final String clientAddress;
    public final String requestUri;
    public final String currentQueryId;
    public final String currentQuery;
    public final long activeLockCount;
    public final String status;
    public Map<String, Object> resourceInformation;
    public final long elapsedTimeMillis;
    public final Long cpuTimeMillis;
    public final long waitTimeMillis;
    public final Long idleTimeMillis;
    public final Long allocatedBytes;
    public final Long allocatedDirectBytes;
    public final long pageHits;
    public final long pageFaults;
    public final String connectionId;
    public final String initializationStackTrace;
    public final String database;
    public final Long estimatedUsedHeapMemory;

    public TransactionStatusResult(String database, KernelTransactionHandle transaction, TransactionDependenciesResolver transactionDependenciesResolver, Map<KernelTransactionHandle, Optional<QuerySnapshot>> handleSnapshotsMap, ZoneId zoneId) throws InvalidArgumentsException {
        this.database = database;
        this.transactionId = new TransactionId(database, transaction.getUserTransactionId()).toString();
        this.username = transaction.subject().username();
        this.startTime = ProceduresTimeFormatHelper.formatTime(transaction.startTime(), zoneId);
        this.activeLockCount = transaction.activeLocks().count();
        Optional<QuerySnapshot> querySnapshot = handleSnapshotsMap.get(transaction);
        TransactionExecutionStatistic statistic = transaction.transactionStatistic();
        this.elapsedTimeMillis = statistic.getElapsedTimeMillis();
        this.cpuTimeMillis = statistic.getCpuTimeMillis();
        this.allocatedBytes = statistic.getHeapAllocatedBytes();
        this.allocatedDirectBytes = statistic.getNativeAllocatedBytes();
        this.estimatedUsedHeapMemory = statistic.getEstimatedUsedHeapMemory();
        this.waitTimeMillis = statistic.getWaitTimeMillis();
        this.idleTimeMillis = statistic.getIdleTimeMillis();
        this.pageHits = statistic.getPageHits();
        this.pageFaults = statistic.getPageFaults();
        if (querySnapshot.isPresent()) {
            QuerySnapshot snapshot = querySnapshot.get();
            this.currentQueryId = new QueryId(snapshot.internalQueryId()).toString();
            this.currentQuery = snapshot.obfuscatedQueryText().orElse(null);
        } else {
            this.currentQueryId = "";
            this.currentQuery = "";
        }
        Optional clientInfo = transaction.clientInfo();
        this.protocol = clientInfo.map(ClientConnectionInfo::protocol).orElse("");
        this.clientAddress = clientInfo.map(ClientConnectionInfo::clientAddress).orElse("");
        this.requestUri = clientInfo.map(ClientConnectionInfo::requestURI).orElse("");
        this.connectionId = clientInfo.map(ClientConnectionInfo::connectionId).orElse("");
        this.resourceInformation = transactionDependenciesResolver.describeBlockingLocks(transaction);
        this.status = TransactionStatusResult.getStatus(transaction, transactionDependenciesResolver);
        this.metaData = transaction.getMetaData();
        this.initializationStackTrace = transaction.transactionInitialisationTrace().getTrace();
    }

    private static String getStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        return handle.terminationReason().map(reason -> String.format(TERMINATED_STATE, reason.code())).orElseGet(() -> TransactionStatusResult.getExecutingStatus(handle, transactionDependenciesResolver));
    }

    private static String getExecutingStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        if (transactionDependenciesResolver.isBlocked(handle)) {
            return BLOCKED_STATE + transactionDependenciesResolver.describeBlockingTransactions(handle);
        }
        if (handle.isClosing()) {
            return CLOSING_STATE;
        }
        return RUNNING_STATE;
    }
}

