/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.builtin.NodePropertySchemaInfoResult;
import org.neo4j.procedure.builtin.RelationshipPropertySchemaInfoResult;
import org.neo4j.procedure.builtin.SortedLabels;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.Value;

public class SchemaCalculator {
    private Map<Integer, String> propertyIdToPropertyNameMapping;
    private final MutableIntSet emptyPropertyIdSet = IntSets.mutable.empty();
    private final Read dataRead;
    private final TokenRead tokenRead;
    private final CursorFactory cursors;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;

    SchemaCalculator(KernelTransaction ktx) {
        this.dataRead = ktx.dataRead();
        this.tokenRead = ktx.tokenRead();
        this.cursors = ktx.cursors();
        this.cursorTracer = ktx.pageCursorTracer();
        this.memoryTracker = ktx.memoryTracker();
        this.propertyIdToPropertyNameMapping = new HashMap<Integer, String>(this.tokenRead.propertyKeyCount());
        this.addNamesToCollection(this.tokenRead.propertyKeyGetAllTokens(), this.propertyIdToPropertyNameMapping);
    }

    private NodeMappings initializeMappingsForNodes() {
        int labelCount = this.tokenRead.labelCount();
        return new NodeMappings(labelCount);
    }

    private RelationshipMappings initializeMappingsForRels() {
        int relationshipTypeCount = this.tokenRead.relationshipTypeCount();
        return new RelationshipMappings(relationshipTypeCount);
    }

    public Stream<NodePropertySchemaInfoResult> calculateTabularResultStreamForNodes() {
        NodeMappings nodeMappings = this.initializeMappingsForNodes();
        this.scanEverythingBelongingToNodes(nodeMappings, this.cursorTracer, this.memoryTracker);
        this.addNamesToCollection(this.tokenRead.labelsGetAllTokens(), nodeMappings.labelIdToLabelName);
        return this.produceResultsForNodes(nodeMappings).stream();
    }

    public Stream<RelationshipPropertySchemaInfoResult> calculateTabularResultStreamForRels() {
        RelationshipMappings relMappings = this.initializeMappingsForRels();
        this.scanEverythingBelongingToRelationships(relMappings, this.cursorTracer, this.memoryTracker);
        this.addNamesToCollection(this.tokenRead.relationshipTypesGetAllTokens(), relMappings.relationshipTypIdToRelationshipName);
        return this.produceResultsForRelationships(relMappings).stream();
    }

    private List<RelationshipPropertySchemaInfoResult> produceResultsForRelationships(RelationshipMappings relMappings) {
        ArrayList<RelationshipPropertySchemaInfoResult> results = new ArrayList<RelationshipPropertySchemaInfoResult>();
        for (Integer typeId : relMappings.relationshipTypeIdToPropertyKeys.keySet()) {
            Object name = relMappings.relationshipTypIdToRelationshipName.get(typeId);
            name = ":`" + (String)name + "`";
            MutableIntSet propertyIds = relMappings.relationshipTypeIdToPropertyKeys.get(typeId);
            if (propertyIds.size() == 0) {
                results.add(new RelationshipPropertySchemaInfoResult((String)name, null, null, false));
                continue;
            }
            Object finalName = name;
            propertyIds.forEach(arg_0 -> this.lambda$produceResultsForRelationships$36e57439$1(relMappings, typeId, results, (String)finalName, arg_0));
        }
        return results;
    }

    private List<NodePropertySchemaInfoResult> produceResultsForNodes(NodeMappings nodeMappings) {
        ArrayList<NodePropertySchemaInfoResult> results = new ArrayList<NodePropertySchemaInfoResult>();
        for (SortedLabels labelSet : nodeMappings.labelSetToPropertyKeys.keySet()) {
            ArrayList<String> labelNames = new ArrayList<String>();
            for (int i = 0; i < labelSet.numberOfLabels(); ++i) {
                String name = nodeMappings.labelIdToLabelName.get(labelSet.label(i));
                labelNames.add(name);
            }
            Collections.sort(labelNames);
            StringBuilder labelsConcatenator = new StringBuilder();
            for (String item : labelNames) {
                labelsConcatenator.append(":`").append(item).append('`');
            }
            String labels = labelsConcatenator.toString();
            MutableIntSet propertyIds = nodeMappings.labelSetToPropertyKeys.get(labelSet);
            if (propertyIds.size() == 0) {
                results.add(new NodePropertySchemaInfoResult(labels, labelNames, null, null, false));
                continue;
            }
            propertyIds.forEach((IntProcedure & Serializable)propId -> {
                String propName = this.propertyIdToPropertyNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(Pair.of((Object)labelSet, (Object)propId));
                if (nodeMappings.nullableLabelSets.contains(labelSet)) {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), false));
                } else {
                    results.add(new NodePropertySchemaInfoResult(labels, labelNames, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
                }
            });
        }
        return results;
    }

    private void scanEverythingBelongingToRelationships(RelationshipMappings relMappings, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        try (RelationshipScanCursor relationshipScanCursor = this.cursors.allocateRelationshipScanCursor(cursorTracer);
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(cursorTracer, memoryTracker);){
            this.dataRead.allRelationshipsScan(relationshipScanCursor);
            while (relationshipScanCursor.next()) {
                int typeId = relationshipScanCursor.type();
                relationshipScanCursor.properties(propertyCursor);
                MutableIntSet propertyIds = IntSets.mutable.empty();
                while (propertyCursor.next()) {
                    int propertyKey = propertyCursor.propertyKey();
                    Value currentValue = propertyCursor.propertyValue();
                    Pair key = Pair.of((Object)typeId, (Object)propertyKey);
                    this.updateValueTypeInMapping(currentValue, key, relMappings.relationshipTypeIdANDPropertyTypeIdToValueType);
                    propertyIds.add(propertyKey);
                }
                propertyCursor.close();
                MutableIntSet oldPropertyKeySet = relMappings.relationshipTypeIdToPropertyKeys.getOrDefault(typeId, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        relMappings.nullableRelationshipTypes.add(typeId);
                    }
                    propertyIds.addAll((IntIterable)oldPropertyKeySet);
                } else {
                    IntHashSet currentPropertyIdsHelperSet = new IntHashSet(propertyIds.size());
                    currentPropertyIdsHelperSet.addAll((IntIterable)propertyIds);
                    propertyIds.removeAll((IntIterable)oldPropertyKeySet);
                    oldPropertyKeySet.removeAll((IntIterable)currentPropertyIdsHelperSet);
                    propertyIds.addAll((IntIterable)oldPropertyKeySet);
                    propertyIds.forEach((IntProcedure & Serializable)id -> {
                        Pair key = Pair.of((Object)typeId, (Object)id);
                        relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(key).setNullable();
                    });
                    propertyIds.addAll((IntIterable)currentPropertyIdsHelperSet);
                }
                relMappings.relationshipTypeIdToPropertyKeys.put(typeId, propertyIds);
            }
        }
    }

    private void scanEverythingBelongingToNodes(NodeMappings nodeMappings, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor(cursorTracer);
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(cursorTracer, memoryTracker);){
            this.dataRead.allNodesScan(nodeCursor);
            while (nodeCursor.next()) {
                SortedLabels labels = SortedLabels.from(nodeCursor.labels());
                nodeCursor.properties(propertyCursor);
                MutableIntSet propertyIds = IntSets.mutable.empty();
                while (propertyCursor.next()) {
                    Value currentValue = propertyCursor.propertyValue();
                    int propertyKeyId = propertyCursor.propertyKey();
                    Pair key = Pair.of((Object)labels, (Object)propertyKeyId);
                    this.updateValueTypeInMapping(currentValue, key, nodeMappings.labelSetANDNodePropertyKeyIdToValueType);
                    propertyIds.add(propertyKeyId);
                }
                propertyCursor.close();
                MutableIntSet oldPropertyKeySet = nodeMappings.labelSetToPropertyKeys.getOrDefault(labels, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        nodeMappings.nullableLabelSets.add(labels);
                    }
                    propertyIds.addAll((IntIterable)oldPropertyKeySet);
                } else {
                    IntHashSet currentPropertyIdsHelperSet = new IntHashSet(propertyIds.size());
                    currentPropertyIdsHelperSet.addAll((IntIterable)propertyIds);
                    propertyIds.removeAll((IntIterable)oldPropertyKeySet);
                    oldPropertyKeySet.removeAll((IntIterable)currentPropertyIdsHelperSet);
                    propertyIds.addAll((IntIterable)oldPropertyKeySet);
                    propertyIds.forEach((IntProcedure & Serializable)id -> {
                        Pair key = Pair.of((Object)labels, (Object)id);
                        nodeMappings.labelSetANDNodePropertyKeyIdToValueType.get(key).setNullable();
                    });
                    propertyIds.addAll((IntIterable)currentPropertyIdsHelperSet);
                }
                nodeMappings.labelSetToPropertyKeys.put(labels, propertyIds);
            }
        }
    }

    private <X, Y> void updateValueTypeInMapping(Value currentValue, Pair<X, Y> key, Map<Pair<X, Y>, ValueTypeListHelper> mappingToUpdate) {
        ValueTypeListHelper helper = mappingToUpdate.get(key);
        if (helper == null) {
            helper = new ValueTypeListHelper(currentValue);
            mappingToUpdate.put(key, helper);
        } else {
            helper.updateValueTypesWith(currentValue);
        }
    }

    private void addNamesToCollection(Iterator<NamedToken> labelIterator, Map<Integer, String> collection) {
        while (labelIterator.hasNext()) {
            NamedToken label = labelIterator.next();
            collection.put(label.id(), label.name());
        }
    }

    private /* synthetic */ void lambda$produceResultsForRelationships$36e57439$1(RelationshipMappings relMappings, Integer typeId, List results, String finalName, int propId) {
        String propName = this.propertyIdToPropertyNameMapping.get(propId);
        ValueTypeListHelper valueTypeListHelper = relMappings.relationshipTypeIdANDPropertyTypeIdToValueType.get(Pair.of((Object)typeId, (Object)propId));
        if (relMappings.nullableRelationshipTypes.contains(typeId)) {
            results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), false));
        } else {
            results.add(new RelationshipPropertySchemaInfoResult(finalName, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isMandatory()));
        }
    }

    private static class RelationshipMappings {
        final Map<Integer, String> relationshipTypIdToRelationshipName;
        final Map<Integer, MutableIntSet> relationshipTypeIdToPropertyKeys;
        final Map<Pair<Integer, Integer>, ValueTypeListHelper> relationshipTypeIdANDPropertyTypeIdToValueType;
        final Set<Integer> nullableRelationshipTypes;

        RelationshipMappings(int relationshipTypeCount) {
            this.relationshipTypIdToRelationshipName = new HashMap<Integer, String>(relationshipTypeCount);
            this.relationshipTypeIdToPropertyKeys = new HashMap<Integer, MutableIntSet>(relationshipTypeCount);
            this.relationshipTypeIdANDPropertyTypeIdToValueType = new HashMap<Pair<Integer, Integer>, ValueTypeListHelper>();
            this.nullableRelationshipTypes = new HashSet<Integer>();
        }
    }

    private static class NodeMappings {
        final Map<SortedLabels, MutableIntSet> labelSetToPropertyKeys;
        final Map<Pair<SortedLabels, Integer>, ValueTypeListHelper> labelSetANDNodePropertyKeyIdToValueType;
        final Set<SortedLabels> nullableLabelSets;
        final Map<Integer, String> labelIdToLabelName;

        NodeMappings(int labelCount) {
            this.labelSetToPropertyKeys = new HashMap<SortedLabels, MutableIntSet>(labelCount);
            this.labelIdToLabelName = new HashMap<Integer, String>(labelCount);
            this.labelSetANDNodePropertyKeyIdToValueType = new HashMap<Pair<SortedLabels, Integer>, ValueTypeListHelper>();
            this.nullableLabelSets = new HashSet<SortedLabels>();
        }
    }

    private static class ValueTypeListHelper {
        private final Set<String> seenValueTypes = new HashSet<String>();
        private boolean isMandatory = true;

        ValueTypeListHelper(Value v) {
            this.updateValueTypesWith(v);
        }

        private void setNullable() {
            this.isMandatory = false;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        List<String> getCypherTypesList() {
            return new ArrayList<String>(this.seenValueTypes);
        }

        void updateValueTypesWith(Value newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException();
            }
            this.seenValueTypes.add(newValue.getTypeName());
        }
    }
}

