/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.core.TransactionalEntityFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.ConfigResult;
import org.neo4j.procedure.builtin.ConnectionTerminationFailedResult;
import org.neo4j.procedure.builtin.ConnectionTerminationResult;
import org.neo4j.procedure.builtin.ListConnectionResult;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.QueryId;
import org.neo4j.procedure.builtin.QueryStatusResult;
import org.neo4j.procedure.builtin.StoreIdDecodeUtils;
import org.neo4j.procedure.builtin.TransactionDependenciesResolver;
import org.neo4j.procedure.builtin.TransactionId;
import org.neo4j.procedure.builtin.TransactionMarkForTerminationFailedResult;
import org.neo4j.procedure.builtin.TransactionMarkForTerminationResult;
import org.neo4j.procedure.builtin.TransactionStatusResult;
import org.neo4j.storageengine.api.StoreIdProvider;

public class BuiltInDbmsProcedures {
    private static final int HARD_CHAR_LIMIT = 2048;
    @Context
    public Log log;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public Transaction transaction;
    @Context
    public SecurityContext securityContext;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public SystemGraphComponents systemGraphComponents;

    @SystemProcedure
    @Description(value="Provides information regarding the DBMS.")
    @Procedure(name="dbms.info", mode=Mode.DBMS)
    public Stream<SystemInfo> databaseInfo() throws NoSuchAlgorithmException {
        GraphDatabaseAPI systemGraph = this.getSystemDatabase();
        StoreIdProvider storeIdProvider = this.getSystemDatabaseStoreIdProvider(systemGraph);
        String creationTime = ProceduresTimeFormatHelper.formatTime(storeIdProvider.getStoreId().getCreationTime(), this.getConfiguredTimeZone());
        return Stream.of(new SystemInfo(StoreIdDecodeUtils.decodeId(storeIdProvider), systemGraph.databaseName(), creationTime));
    }

    @Admin
    @SystemProcedure
    @Description(value="List the currently active config of Neo4j.")
    @Procedure(name="dbms.listConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listConfig(@Name(value="searchString", defaultValue="") String searchString) {
        String lowerCasedSearchString = searchString.toLowerCase();
        ArrayList results = new ArrayList();
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getValues().forEach((setting, value) -> {
            if (!setting.internal() && setting.name().toLowerCase().contains(lowerCasedSearchString)) {
                results.add(new ConfigResult((Setting<Object>)setting, value));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Internal
    @SystemProcedure
    @Description(value="Return config settings interesting to clients (e.g. Neo4j Browser)")
    @Procedure(name="dbms.clientConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listClientConfig() {
        ArrayList results = new ArrayList();
        Set browserSettings = Stream.of("browser.allow_outgoing_connections", "browser.credential_timeout", "browser.retain_connection_credentials", "dbms.security.auth_enabled", "browser.remote_content_hostname_whitelist", "browser.post_connect_cmd", "dbms.default_database").collect(Collectors.toCollection(HashSet::new));
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getValues().forEach((setting, value) -> {
            if (browserSettings.contains(setting.name().toLowerCase())) {
                results.add(new ConfigResult((Setting<Object>)setting, value));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Description(value="Attaches a map of data to the transaction. The data will be printed when listing queries, and inserted into the query log.")
    @Procedure(name="tx.setMetaData", mode=Mode.DBMS)
    public void setTXMetaData(@Name(value="data") Map<String, Object> data) {
        this.securityContext.assertCredentialsNotExpired();
        int totalCharSize = data.entrySet().stream().mapToInt(e -> ((String)e.getKey()).length() + (e.getValue() != null ? e.getValue().toString().length() : 0)).sum();
        if (totalCharSize >= 2048) {
            throw new IllegalArgumentException(String.format("Invalid transaction meta-data, expected the total number of chars for keys and values to be less than %d, got %d", 2048, totalCharSize));
        }
        InternalTransaction internalTransaction = (InternalTransaction)this.transaction;
        ((TransactionManager)this.graph.getDependencyResolver().resolveDependency(TransactionManager.class)).findTransactionContaining(internalTransaction).ifPresentOrElse(parent -> parent.setMetaData(data), () -> internalTransaction.setMetaData(data));
    }

    @SystemProcedure
    @Description(value="Provides attached transaction metadata.")
    @Procedure(name="tx.getMetaData", mode=Mode.DBMS)
    public Stream<MetadataResult> getTXMetaData() {
        this.securityContext.assertCredentialsNotExpired();
        return Stream.of(((InternalTransaction)this.transaction).kernelTransaction().getMetaData()).map(MetadataResult::new);
    }

    @SystemProcedure
    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        this.securityContext.assertCredentialsNotExpired();
        return ((GlobalProcedures)this.graph.getDependencyResolver().resolveDependency(GlobalProcedures.class)).getAllProcedures().stream().filter(proc -> !proc.internal()).sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    @SystemProcedure
    @Description(value="List all functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        this.securityContext.assertCredentialsNotExpired();
        DependencyResolver resolver = this.graph.getDependencyResolver();
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        List providedLanguageFunctions = queryExecutionEngine.getProvidedLanguageFunctions();
        GlobalProcedures globalProcedures = (GlobalProcedures)resolver.resolveDependency(GlobalProcedures.class);
        Stream<FunctionResult> languageFunctions = providedLanguageFunctions.stream().map(x$0 -> new FunctionResult((FunctionInformation)x$0));
        Stream<FunctionResult> loadedFunctions = globalProcedures.getAllNonAggregatingFunctions().map(f -> new FunctionResult((UserFunctionSignature)f, false));
        Stream<FunctionResult> loadedAggregationFunctions = globalProcedures.getAllAggregatingFunctions().map(f -> new FunctionResult((UserFunctionSignature)f, true));
        return Stream.concat(Stream.concat(languageFunctions, loadedFunctions), loadedAggregationFunctions).sorted(Comparator.comparing(a -> a.name));
    }

    @Admin
    @SystemProcedure
    @Description(value="Clears all query caches.")
    @Procedure(name="db.clearQueryCaches", mode=Mode.DBMS)
    public Stream<StringResult> clearAllQueryCaches() {
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.graph.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        long numberOfClearedQueries = queryExecutionEngine.clearQueryCaches() - 1L;
        Object result = numberOfClearedQueries == 0L ? "Query cache already empty." : "Query caches successfully cleared of " + numberOfClearedQueries + " queries.";
        this.log.info("Called db.clearQueryCaches(): " + (String)result);
        return Stream.of(new StringResult((String)result));
    }

    @Admin
    @SystemProcedure
    @Description(value="Report the current status of the system database sub-graph schema.")
    @Procedure(name="dbms.upgradeStatus", mode=Mode.READ)
    public Stream<SystemGraphComponentStatusResult> upgradeStatus() throws ProcedureException {
        this.assertAllowedUpgradeProc();
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgradeStatus", new Object[0]);
        }
        return Stream.of(new SystemGraphComponentStatusResult(this.systemGraphComponents.detect(this.transaction)));
    }

    @Admin
    @SystemProcedure
    @Description(value="Upgrade the system database schema if it is not the current schema.")
    @Procedure(name="dbms.upgrade", mode=Mode.WRITE)
    public Stream<SystemGraphComponentUpgradeResult> upgrade() throws ProcedureException {
        this.assertAllowedUpgradeProc();
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgrade", new Object[0]);
        }
        SystemGraphComponents versions = this.systemGraphComponents;
        SystemGraphComponent.Status status = versions.detect(this.transaction);
        List<SystemGraphComponent.Status> upgradableStatuses = List.of(SystemGraphComponent.Status.REQUIRES_UPGRADE, SystemGraphComponent.Status.UNINITIALIZED);
        if (upgradableStatuses.contains(status)) {
            ArrayList failed = new ArrayList();
            versions.forEach(component -> {
                SystemGraphComponent.Status initialStatus = component.detect(this.transaction);
                if (upgradableStatuses.contains(initialStatus)) {
                    try {
                        component.upgradeToCurrent((GraphDatabaseService)this.graph);
                    }
                    catch (Exception e) {
                        failed.add(String.format("[%s] %s", component.component(), e.getMessage()));
                    }
                }
            });
            String upgradeResult = failed.isEmpty() ? "Success" : "Failed: " + String.join((CharSequence)", ", failed);
            return Stream.of(new SystemGraphComponentUpgradeResult(versions.detect(this.transaction).name(), upgradeResult));
        }
        return Stream.of(new SystemGraphComponentUpgradeResult(status.name(), status.resolution()));
    }

    private void assertAllowedUpgradeProc() {
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        if (((Boolean)config.get(GraphDatabaseInternalSettings.restrict_upgrade)).booleanValue() && !this.securityContext.subject().hasUsername((String)config.get(GraphDatabaseInternalSettings.upgrade_username))) {
            throw new AuthorizationViolationException(String.format("%s Execution of this procedure has been restricted by the system.", "Permission denied."));
        }
    }

    @SystemProcedure
    @Description(value="List all transactions currently executing at this instance that are visible to the user.")
    @Procedure(name="dbms.listTransactions", mode=Mode.DBMS)
    public Stream<TransactionStatusResult> listTransactions() throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        ZoneId zoneId = this.getConfiguredTimeZone();
        ArrayList<TransactionStatusResult> result = new ArrayList<TransactionStatusResult>();
        for (DatabaseContext databaseContext : this.getDatabaseManager().registeredDatabases().values()) {
            if (!databaseContext.database().isStarted()) continue;
            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(databaseContext.database().getNamedDatabaseId().name());
            HashMap<KernelTransactionHandle, Optional<QuerySnapshot>> handleQuerySnapshotsMap = new HashMap<KernelTransactionHandle, Optional<QuerySnapshot>>();
            for (KernelTransactionHandle tx : BuiltInDbmsProcedures.getExecutingTransactions(databaseContext)) {
                AdminActionOnResource action;
                String username = tx.subject().username();
                if (!this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.SHOW_TRANSACTION, dbScope, (Segment)new UserSegment(username)))) continue;
                handleQuerySnapshotsMap.put(tx, tx.executingQuery().map(ExecutingQuery::snapshot));
            }
            TransactionDependenciesResolver transactionBlockerResolvers = new TransactionDependenciesResolver(handleQuerySnapshotsMap);
            for (KernelTransactionHandle tx : handleQuerySnapshotsMap.keySet()) {
                result.add(new TransactionStatusResult(databaseContext.databaseFacade().databaseName(), tx, transactionBlockerResolvers, handleQuerySnapshotsMap, zoneId));
            }
        }
        return result.stream();
    }

    @SystemProcedure
    @Description(value="Kill transaction with provided id.")
    @Procedure(name="dbms.killTransaction", mode=Mode.DBMS)
    public Stream<TransactionMarkForTerminationResult> killTransaction(@Name(value="id") String transactionId) throws InvalidArgumentsException {
        Objects.requireNonNull(transactionId);
        return this.killTransactions(Collections.singletonList(transactionId));
    }

    @SystemProcedure
    @Description(value="Kill transactions with provided ids.")
    @Procedure(name="dbms.killTransactions", mode=Mode.DBMS)
    public Stream<TransactionMarkForTerminationResult> killTransactions(@Name(value="ids") List<String> transactionIds) throws InvalidArgumentsException {
        Objects.requireNonNull(transactionIds);
        this.securityContext.assertCredentialsNotExpired();
        this.log.warn("User %s trying to kill transactions: %s.", new Object[]{this.securityContext.subject().username(), transactionIds.toString()});
        DatabaseManager<DatabaseContext> databaseManager = this.getDatabaseManager();
        DatabaseIdRepository.Caching databaseIdRepository = databaseManager.databaseIdRepository();
        HashMap byDatabase = new HashMap();
        for (String idText : transactionIds) {
            TransactionId id2 = TransactionId.parse(idText);
            Optional namedDatabaseId = databaseIdRepository.getByName(id2.database());
            namedDatabaseId.ifPresent(databaseId -> byDatabase.computeIfAbsent(databaseId, ignore -> new HashSet()).add(id2));
        }
        HashMap<String, KernelTransactionHandle> handles = new HashMap<String, KernelTransactionHandle>(transactionIds.size());
        for (Map.Entry entry : byDatabase.entrySet()) {
            NamedDatabaseId databaseId2 = (NamedDatabaseId)entry.getKey();
            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(databaseId2.name());
            Optional maybeDatabaseContext = databaseManager.getDatabaseContext(databaseId2);
            if (!maybeDatabaseContext.isPresent()) continue;
            Set txIds = (Set)entry.getValue();
            DatabaseContext databaseContext = (DatabaseContext)maybeDatabaseContext.get();
            for (KernelTransactionHandle tx : BuiltInDbmsProcedures.getExecutingTransactions(databaseContext)) {
                TransactionId txIdRepresentation;
                AdminActionOnResource action;
                String username = tx.subject().username();
                if (!this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, dbScope, (Segment)new UserSegment(username))) || !txIds.contains(txIdRepresentation = new TransactionId(databaseId2.name(), tx.getUserTransactionId()))) continue;
                handles.put(txIdRepresentation.toString(), tx);
            }
        }
        return transactionIds.stream().map(id -> this.terminateTransaction((Map<String, KernelTransactionHandle>)handles, (String)id));
    }

    @SystemProcedure
    @Description(value="List all queries currently executing at this instance that are visible to the user.")
    @Procedure(name="dbms.listQueries", mode=Mode.DBMS)
    public Stream<QueryStatusResult> listQueries() throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        ZoneId zoneId = this.getConfiguredTimeZone();
        ArrayList<QueryStatusResult> result = new ArrayList<QueryStatusResult>();
        for (FabricTransaction tx : this.getFabricTransactions()) {
            for (ExecutingQuery query : this.getActiveFabricQueries(tx)) {
                AdminActionOnResource action;
                String username = query.username();
                if (!this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.SHOW_TRANSACTION, AdminActionOnResource.DatabaseScope.ALL, (Segment)new UserSegment(username)))) continue;
                result.add(new QueryStatusResult(query, (TransactionalEntityFactory)((InternalTransaction)this.transaction), zoneId, "none"));
            }
        }
        for (DatabaseContext databaseContext : this.getDatabaseManager().registeredDatabases().values()) {
            if (!databaseContext.database().isStarted()) continue;
            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(databaseContext.database().getNamedDatabaseId().name());
            for (KernelTransactionHandle tx : BuiltInDbmsProcedures.getExecutingTransactions(databaseContext)) {
                if (!tx.executingQuery().isPresent()) continue;
                for (ExecutingQuery query = (ExecutingQuery)tx.executingQuery().get(); query != null; query = query.getPreviousQuery()) {
                    AdminActionOnResource action;
                    String username = query.username();
                    if (!this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.SHOW_TRANSACTION, dbScope, (Segment)new UserSegment(username)))) continue;
                    result.add(new QueryStatusResult(query, (TransactionalEntityFactory)((InternalTransaction)this.transaction), zoneId, databaseContext.databaseFacade().databaseName()));
                }
            }
        }
        return result.stream();
    }

    @SystemProcedure
    @Description(value="Kill all transactions executing the query with the given query id.")
    @Procedure(name="dbms.killQuery", mode=Mode.DBMS)
    public Stream<QueryTerminationResult> killQuery(@Name(value="id") String idText) throws InvalidArgumentsException {
        return this.killQueries(Collections.singletonList(idText));
    }

    @SystemProcedure
    @Description(value="Kill all transactions executing a query with any of the given query ids.")
    @Procedure(name="dbms.killQueries", mode=Mode.DBMS)
    public Stream<QueryTerminationResult> killQueries(@Name(value="ids") List<String> idTexts) throws InvalidArgumentsException {
        this.securityContext.assertCredentialsNotExpired();
        DatabaseManager<DatabaseContext> databaseManager = this.getDatabaseManager();
        DatabaseIdRepository.Caching databaseIdRepository = databaseManager.databaseIdRepository();
        HashMap<Long, QueryId> queryIds = new HashMap<Long, QueryId>(idTexts.size());
        for (String idText : idTexts) {
            QueryId queryId = QueryId.parse(idText);
            queryIds.put(queryId.internalId(), queryId);
        }
        ArrayList<QueryTerminationResult> result = new ArrayList<QueryTerminationResult>(queryIds.size());
        for (FabricTransaction fabricTransaction : this.getFabricTransactions()) {
            for (ExecutingQuery query : this.getActiveFabricQueries(fabricTransaction)) {
                QueryId givenQueryId = (QueryId)queryIds.remove(query.internalQueryId());
                if (givenQueryId == null) continue;
                result.add(this.killFabricQueryTransaction(givenQueryId, fabricTransaction, query));
            }
        }
        for (Map.Entry entry : databaseManager.registeredDatabases().entrySet()) {
            NamedDatabaseId databaseId = (NamedDatabaseId)entry.getKey();
            DatabaseContext databaseContext = (DatabaseContext)entry.getValue();
            if (!databaseContext.database().isStarted()) continue;
            for (KernelTransactionHandle tx : BuiltInDbmsProcedures.getExecutingTransactions(databaseContext)) {
                QueryId givenQueryId;
                if (!tx.executingQuery().isPresent() || (givenQueryId = (QueryId)queryIds.remove(((ExecutingQuery)tx.executingQuery().get()).internalQueryId())) == null) continue;
                result.add(this.killQueryTransaction(givenQueryId, tx, databaseId));
            }
        }
        for (QueryId queryId : queryIds.values()) {
            result.add(new QueryFailedTerminationResult(queryId, "n/a", "No Query found with this id"));
        }
        return result.stream();
    }

    @SystemProcedure
    @Description(value="List all accepted network connections at this instance that are visible to the user.")
    @Procedure(name="dbms.listConnections", mode=Mode.DBMS)
    public Stream<ListConnectionResult> listConnections() {
        this.securityContext.assertCredentialsNotExpired();
        NetworkConnectionTracker connectionTracker = this.getConnectionTracker();
        ZoneId timeZone = this.getConfiguredTimeZone();
        return connectionTracker.activeConnections().stream().filter(connection -> this.isAdminOrSelf(connection.username())).map(connection -> new ListConnectionResult((TrackedNetworkConnection)connection, timeZone));
    }

    @SystemProcedure
    @Description(value="Kill network connection with the given connection id.")
    @Procedure(name="dbms.killConnection", mode=Mode.DBMS)
    public Stream<ConnectionTerminationResult> killConnection(@Name(value="id") String id) {
        return this.killConnections(Collections.singletonList(id));
    }

    @SystemProcedure
    @Description(value="Kill all network connections with the given connection ids.")
    @Procedure(name="dbms.killConnections", mode=Mode.DBMS)
    public Stream<ConnectionTerminationResult> killConnections(@Name(value="ids") List<String> ids) {
        this.securityContext.assertCredentialsNotExpired();
        NetworkConnectionTracker connectionTracker = this.getConnectionTracker();
        return ids.stream().map(id -> this.killConnection((String)id, connectionTracker));
    }

    private NetworkConnectionTracker getConnectionTracker() {
        return (NetworkConnectionTracker)this.resolver.resolveDependency(NetworkConnectionTracker.class);
    }

    private ConnectionTerminationResult killConnection(String id, NetworkConnectionTracker connectionTracker) {
        TrackedNetworkConnection connection = connectionTracker.get(id);
        if (connection != null) {
            if (this.isAdminOrSelf(connection.username())) {
                connection.close();
                return new ConnectionTerminationResult(id, connection.username());
            }
            throw new AuthorizationViolationException(String.format("Executing admin procedure is not allowed for %s.", this.securityContext.description()));
        }
        return new ConnectionTerminationFailedResult(id);
    }

    private QueryTerminationResult killQueryTransaction(QueryId queryId, KernelTransactionHandle handle, NamedDatabaseId databaseId) {
        AdminActionOnResource action;
        Optional query = handle.executingQuery();
        ExecutingQuery executingQuery = (ExecutingQuery)query.orElseThrow(() -> new IllegalStateException("Query should exist since we filtered based on query ids"));
        String username = executingQuery.username();
        if (this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, new AdminActionOnResource.DatabaseScope(databaseId.name()), (Segment)new UserSegment(username)))) {
            if (handle.isClosing()) {
                return new QueryFailedTerminationResult(queryId, username, "Unable to kill queries when underlying transaction is closing.");
            }
            handle.markForTermination((Status)Status.Transaction.Terminated);
            return new QueryTerminationResult(queryId, username, "Query found");
        }
        throw new AuthorizationViolationException("Permission denied.");
    }

    private QueryTerminationResult killFabricQueryTransaction(QueryId queryId, FabricTransaction tx, ExecutingQuery query) {
        AdminActionOnResource action;
        String username = query.username();
        if (this.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, AdminActionOnResource.DatabaseScope.ALL, (Segment)new UserSegment(username)))) {
            tx.markForTermination((Status)Status.Transaction.Terminated);
            return new QueryTerminationResult(queryId, username, "Query found");
        }
        throw new AuthorizationViolationException("Permission denied.");
    }

    private Set<FabricTransaction> getFabricTransactions() {
        return this.getFabricTransactionManager().getOpenTransactions();
    }

    private List<ExecutingQuery> getActiveFabricQueries(FabricTransaction tx) {
        return tx.getLastSubmittedStatement().stream().filter(FabricStatementLifecycles.StatementLifecycle::inFabricPhase).map(FabricStatementLifecycles.StatementLifecycle::getMonitoredQuery).collect(Collectors.toList());
    }

    private TransactionManager getFabricTransactionManager() {
        return (TransactionManager)this.resolver.resolveDependency(TransactionManager.class);
    }

    private TransactionMarkForTerminationResult terminateTransaction(Map<String, KernelTransactionHandle> handles, String transactionId) {
        KernelTransactionHandle handle = handles.get(transactionId);
        String currentUser = this.securityContext.subject().username();
        if (handle == null) {
            return new TransactionMarkForTerminationFailedResult(transactionId, currentUser);
        }
        if (handle.isClosing()) {
            return new TransactionMarkForTerminationFailedResult(transactionId, currentUser, "Unable to kill closing transactions.");
        }
        this.log.debug("User %s terminated transaction %s.", new Object[]{currentUser, transactionId});
        handle.markForTermination((Status)Status.Transaction.Terminated);
        return new TransactionMarkForTerminationResult(transactionId, handle.subject().username());
    }

    private static Set<KernelTransactionHandle> getExecutingTransactions(DatabaseContext databaseContext) {
        Dependencies dependencies = databaseContext.dependencies();
        if (dependencies != null) {
            return ((KernelTransactions)dependencies.resolveDependency(KernelTransactions.class)).executingTransactions();
        }
        return Collections.emptySet();
    }

    private boolean isSelfOrAllows(String username, AdminActionOnResource actionOnResource) {
        return this.securityContext.subject().hasUsername(username) || this.securityContext.allowsAdminAction(actionOnResource);
    }

    private boolean isAdminOrSelf(String username) {
        return this.securityContext.allowExecuteAdminProcedure(this.callContext.id()) || this.securityContext.subject().hasUsername(username);
    }

    private GraphDatabaseAPI getSystemDatabase() {
        return (GraphDatabaseAPI)((DatabaseManagementService)this.graph.getDependencyResolver().resolveDependency(DatabaseManagementService.class)).database("system");
    }

    private StoreIdProvider getSystemDatabaseStoreIdProvider(GraphDatabaseAPI databaseAPI) {
        return (StoreIdProvider)databaseAPI.getDependencyResolver().resolveDependency(StoreIdProvider.class);
    }

    private DatabaseManager<DatabaseContext> getDatabaseManager() {
        return (DatabaseManager)this.resolver.resolveDependency(DatabaseManager.class);
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public static class QueryFailedTerminationResult
    extends QueryTerminationResult {
        public QueryFailedTerminationResult(QueryId queryId, String username, String message) {
            super(queryId, username, message);
        }
    }

    public static class QueryTerminationResult {
        public final String queryId;
        public final String username;
        public final String message;

        public QueryTerminationResult(QueryId queryId, String username, String message) {
            this.queryId = queryId.toString();
            this.username = username;
            this.message = message;
        }
    }

    public static class SystemGraphComponentUpgradeResult {
        public final String status;
        public final String upgradeResult;

        SystemGraphComponentUpgradeResult(String status, String upgradeResult) {
            this.status = status;
            this.upgradeResult = upgradeResult;
        }
    }

    public static class SystemGraphComponentStatusResult {
        public final String status;
        public final String description;
        public final String resolution;

        SystemGraphComponentStatusResult(SystemGraphComponent.Status status) {
            this.status = status.name();
            this.description = status.description();
            this.resolution = status.resolution();
        }
    }

    public static class MetadataResult {
        public final Map<String, Object> metadata;

        MetadataResult(Map<String, Object> metadata) {
            this.metadata = metadata;
        }
    }

    public static class StringResult {
        public final String value;

        StringResult(String value) {
            this.value = value;
        }
    }

    public static class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;
        public final String mode;
        public final List<String> defaultBuiltInRoles = null;
        public final boolean worksOnSystem;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.mode = signature.mode().toString();
            this.worksOnSystem = signature.systemProcedure();
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String category;
        public final String description;
        public final boolean aggregating;
        public final List<String> defaultBuiltInRoles = null;

        private FunctionResult(UserFunctionSignature signature, boolean isAggregation) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.category = signature.category().orElse("");
            this.description = signature.description().orElse("");
            this.aggregating = isAggregation;
        }

        private FunctionResult(FunctionInformation info) {
            this.name = info.getFunctionName();
            this.signature = info.getSignature();
            this.category = info.getCategory();
            this.description = info.getDescription();
            this.aggregating = info.isAggregationFunction();
        }
    }

    public static class SystemInfo {
        public final String id;
        public final String name;
        public final String creationDate;

        public SystemInfo(String id, String name, String creationDate) {
            this.id = id;
            this.name = name;
            this.creationDate = creationDate;
        }
    }
}

