/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.ConfigResult;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.procedure.builtin.StoreIdDecodeUtils;
import org.neo4j.storageengine.api.StoreIdProvider;

public class BuiltInDbmsProcedures {
    private static final int HARD_CHAR_LIMIT = 2048;
    @Context
    public Log log;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public Transaction transaction;
    @Context
    public SecurityContext securityContext;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public SystemGraphComponents systemGraphComponents;

    @SystemProcedure
    @Description(value="Provides information regarding the DBMS.")
    @Procedure(name="dbms.info", mode=Mode.DBMS)
    public Stream<SystemInfo> databaseInfo() throws NoSuchAlgorithmException {
        GraphDatabaseAPI systemGraph = this.getSystemDatabase();
        StoreIdProvider storeIdProvider = this.getSystemDatabaseStoreIdProvider(systemGraph);
        String creationTime = ProceduresTimeFormatHelper.formatTime(storeIdProvider.getStoreId().getCreationTime(), this.getConfiguredTimeZone());
        return Stream.of(new SystemInfo(StoreIdDecodeUtils.decodeId(storeIdProvider), systemGraph.databaseName(), creationTime));
    }

    @Admin
    @SystemProcedure
    @Description(value="List the currently active config of Neo4j.")
    @Procedure(name="dbms.listConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listConfig(@Name(value="searchString", defaultValue="") String searchString) {
        String lowerCasedSearchString = searchString.toLowerCase();
        ArrayList results = new ArrayList();
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getValues().forEach((setting, value) -> {
            if (!setting.internal() && setting.name().toLowerCase().contains(lowerCasedSearchString)) {
                results.add(new ConfigResult((Setting<Object>)setting, value));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Internal
    @SystemProcedure
    @Description(value="Return config settings interesting to clients (e.g. Neo4j Browser)")
    @Procedure(name="dbms.clientConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listClientConfig() {
        ArrayList results = new ArrayList();
        Set browserSettings = Stream.of("browser.allow_outgoing_connections", "browser.credential_timeout", "browser.retain_connection_credentials", "dbms.security.auth_enabled", "browser.remote_content_hostname_whitelist", "browser.post_connect_cmd", "dbms.default_database").collect(Collectors.toCollection(HashSet::new));
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getValues().forEach((setting, value) -> {
            if (browserSettings.contains(setting.name().toLowerCase())) {
                results.add(new ConfigResult((Setting<Object>)setting, value));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Description(value="Attaches a map of data to the transaction. The data will be printed when listing queries, and inserted into the query log.")
    @Procedure(name="tx.setMetaData", mode=Mode.DBMS)
    public void setTXMetaData(@Name(value="data") Map<String, Object> data) {
        this.securityContext.assertCredentialsNotExpired();
        int totalCharSize = data.entrySet().stream().mapToInt(e -> ((String)e.getKey()).length() + (e.getValue() != null ? e.getValue().toString().length() : 0)).sum();
        if (totalCharSize >= 2048) {
            throw new IllegalArgumentException(String.format("Invalid transaction meta-data, expected the total number of chars for keys and values to be less than %d, got %d", 2048, totalCharSize));
        }
        InternalTransaction internalTransaction = (InternalTransaction)this.transaction;
        ((TransactionManager)this.graph.getDependencyResolver().resolveDependency(TransactionManager.class)).findTransactionContaining(internalTransaction).ifPresentOrElse(parent -> parent.setMetaData(data), () -> internalTransaction.setMetaData(data));
    }

    @SystemProcedure
    @Description(value="Provides attached transaction metadata.")
    @Procedure(name="tx.getMetaData", mode=Mode.DBMS)
    public Stream<MetadataResult> getTXMetaData() {
        this.securityContext.assertCredentialsNotExpired();
        return Stream.of(((InternalTransaction)this.transaction).kernelTransaction().getMetaData()).map(MetadataResult::new);
    }

    @SystemProcedure
    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        this.securityContext.assertCredentialsNotExpired();
        return ((GlobalProcedures)this.graph.getDependencyResolver().resolveDependency(GlobalProcedures.class)).getAllProcedures().stream().filter(proc -> !proc.internal()).sorted(Comparator.comparing(a -> a.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    @SystemProcedure
    @Description(value="List all functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        this.securityContext.assertCredentialsNotExpired();
        DependencyResolver resolver = this.graph.getDependencyResolver();
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        List providedLanguageFunctions = queryExecutionEngine.getProvidedLanguageFunctions();
        GlobalProcedures globalProcedures = (GlobalProcedures)resolver.resolveDependency(GlobalProcedures.class);
        Stream<FunctionResult> languageFunctions = providedLanguageFunctions.stream().map(x$0 -> new FunctionResult((FunctionInformation)x$0));
        Stream<FunctionResult> loadedFunctions = globalProcedures.getAllNonAggregatingFunctions().map(f -> new FunctionResult((UserFunctionSignature)f, false));
        Stream<FunctionResult> loadedAggregationFunctions = globalProcedures.getAllAggregatingFunctions().map(f -> new FunctionResult((UserFunctionSignature)f, true));
        return Stream.concat(Stream.concat(languageFunctions, loadedFunctions), loadedAggregationFunctions).sorted(Comparator.comparing(a -> a.name));
    }

    @Admin
    @SystemProcedure
    @Description(value="Clears all query caches.")
    @Procedure(name="db.clearQueryCaches", mode=Mode.DBMS)
    public Stream<StringResult> clearAllQueryCaches() {
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.graph.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        long numberOfClearedQueries = queryExecutionEngine.clearQueryCaches() - 1L;
        Object result = numberOfClearedQueries == 0L ? "Query cache already empty." : "Query caches successfully cleared of " + numberOfClearedQueries + " queries.";
        this.log.info("Called db.clearQueryCaches(): " + (String)result);
        return Stream.of(new StringResult((String)result));
    }

    @Admin
    @SystemProcedure
    @Description(value="Report the current status of the system database sub-graph schema.")
    @Procedure(name="dbms.upgradeStatus", mode=Mode.READ)
    public Stream<SystemGraphComponentStatusResult> systemSchemaVersion() throws ProcedureException {
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgradeStatus", new Object[0]);
        }
        return Stream.of(new SystemGraphComponentStatusResult(this.systemGraphComponents.detect(this.transaction)));
    }

    @Admin
    @SystemProcedure
    @Description(value="Upgrade the system database schema if it is not the current schema.")
    @Procedure(name="dbms.upgrade", mode=Mode.WRITE)
    public Stream<SystemGraphComponentUpgradeResult> upgradeSystemSchema() throws ProcedureException {
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgrade", new Object[0]);
        }
        SystemGraphComponents versions = this.systemGraphComponents;
        SystemGraphComponent.Status status = versions.detect(this.transaction);
        if (status == SystemGraphComponent.Status.REQUIRES_UPGRADE) {
            ArrayList failed = new ArrayList();
            versions.forEach(component -> {
                SystemGraphComponent.Status initialStatus = component.detect(this.transaction);
                if (initialStatus == SystemGraphComponent.Status.REQUIRES_UPGRADE) {
                    Optional error = component.upgradeToCurrent((GraphDatabaseService)this.graph);
                    error.ifPresent(e -> failed.add(String.format("[%s] %s", component.component(), e.getMessage())));
                }
            });
            String upgradeResult = failed.isEmpty() ? "Success" : "Failed: " + String.join((CharSequence)", ", failed);
            return Stream.of(new SystemGraphComponentUpgradeResult(versions.detect(this.transaction).name(), upgradeResult));
        }
        return Stream.of(new SystemGraphComponentUpgradeResult(status.name(), status.resolution()));
    }

    private GraphDatabaseAPI getSystemDatabase() {
        return (GraphDatabaseAPI)((DatabaseManagementService)this.graph.getDependencyResolver().resolveDependency(DatabaseManagementService.class)).database("system");
    }

    private StoreIdProvider getSystemDatabaseStoreIdProvider(GraphDatabaseAPI databaseAPI) {
        return (StoreIdProvider)databaseAPI.getDependencyResolver().resolveDependency(StoreIdProvider.class);
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public static class SystemGraphComponentUpgradeResult {
        public final String status;
        public final String upgradeResult;

        SystemGraphComponentUpgradeResult(String status, String upgradeResult) {
            this.status = status;
            this.upgradeResult = upgradeResult;
        }
    }

    public static class SystemGraphComponentStatusResult {
        public final String status;
        public final String description;
        public final String resolution;

        SystemGraphComponentStatusResult(SystemGraphComponent.Status status) {
            this.status = status.name();
            this.description = status.description();
            this.resolution = status.resolution();
        }
    }

    public static class MetadataResult {
        public final Map<String, Object> metadata;

        MetadataResult(Map<String, Object> metadata) {
            this.metadata = metadata;
        }
    }

    public static class StringResult {
        public final String value;

        StringResult(String value) {
            this.value = value;
        }
    }

    public static class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;
        public final String mode;
        public final List<String> defaultBuiltInRoles = null;
        public final boolean worksOnSystem;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.mode = signature.mode().toString();
            this.worksOnSystem = signature.systemProcedure();
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String description;
        public final boolean aggregating;
        public final List<String> defaultBuiltInRoles = null;

        private FunctionResult(UserFunctionSignature signature, boolean isAggregation) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
            this.aggregating = isAggregation;
        }

        private FunctionResult(FunctionInformation info) {
            this.name = info.getFunctionName();
            this.signature = info.getSignature();
            this.description = info.getDescription();
            this.aggregating = info.isAggregationFunction();
        }
    }

    public static class SystemInfo {
        public final String id;
        public final String name;
        public final String creationDate;

        public SystemInfo(String id, String name, String creationDate) {
            this.id = id;
            this.name = name;
            this.creationDate = creationDate;
        }
    }
}

