/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.CypherVersionClassification;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public class ListComponentsProcedure
extends CallableProcedure.BasicProcedure {
    private static final String SKIP_CYPHER_VERSION = "internal.components.cypher.skip";
    public static final String NAME_COLUMN = "name";
    public static final String VERSIONS_COLUMN = "versions";
    public static final String EDITION_COLUMN = "edition";
    public static final String KERNEL_COMPONENT_NAME = "Neo4j Kernel";
    private static final TextValue NEO4J_KERNEL = Values.utf8Value((String)"Neo4j Kernel");
    private static final TextValue CYPHER = Values.utf8Value((String)"Cypher");
    private static final GraphDatabaseSettings.CypherVersion[] ALL_CYPHER_VERSIONS = GraphDatabaseSettings.CypherVersion.values();
    private static final ListValue CYPHER_VERSIONS_EXCL_EXPERIMENTAL = ListComponentsProcedure.cypherVersions(false);
    private static final ListValue CYPHER_VERSIONS_INCL_EXPERIMENTAL = ListComponentsProcedure.cypherVersions(true);
    private final List<AnyValue[]> components;

    public ListComponentsProcedure(QualifiedName name, String neo4jVersion, String neo4jEdition, String customVersionConfig, Boolean cypherExperimentalVersionsEnabled) {
        super(ProcedureSignature.procedureSignature((QualifiedName)name).out(NAME_COLUMN, (Neo4jTypes.AnyType)Neo4jTypes.NTString, "The name of the component.").out(VERSIONS_COLUMN, (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTString), "The installed versions of the component.").out(EDITION_COLUMN, (Neo4jTypes.AnyType)Neo4jTypes.NTString, "The Neo4j edition of the DBMS.").mode(Mode.DBMS).description("List DBMS components and their versions.").systemProcedure().build());
        this.components = ListComponentsProcedure.createComponentsList(neo4jVersion, customVersionConfig, neo4jEdition, cypherExperimentalVersionsEnabled);
    }

    public ResourceRawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        return Iterators.asRawIterator(this.components);
    }

    private static List<AnyValue[]> createComponentsList(String neo4jVersion, String customVersionConfig, String neo4jEdition, Boolean cypherExperimentalVersionsEnabled) {
        TextValue version = customVersionConfig != null ? Values.stringValue((String)customVersionConfig) : Values.stringValue((String)neo4jVersion);
        TextValue edition = Values.stringValue((String)neo4jEdition);
        ArrayList<AnyValue[]> components = new ArrayList<AnyValue[]>(2);
        components.add(new AnyValue[]{NEO4J_KERNEL, VirtualValues.list((AnyValue[])new AnyValue[]{version}), edition});
        if (Boolean.getBoolean(SKIP_CYPHER_VERSION)) {
            return components;
        }
        ListValue cypherVersions = cypherExperimentalVersionsEnabled != false ? CYPHER_VERSIONS_INCL_EXPERIMENTAL : CYPHER_VERSIONS_EXCL_EXPERIMENTAL;
        components.add(new AnyValue[]{CYPHER, cypherVersions, Values.EMPTY_STRING});
        return components;
    }

    private static ListValue cypherVersions(boolean includeExperimental) {
        return VirtualValues.fromList(Arrays.stream(ALL_CYPHER_VERSIONS).filter(v -> includeExperimental || !CypherVersionClassification.isExperimental((GraphDatabaseSettings.CypherVersion)v)).map(v -> Values.stringValue((String)CypherVersionClassification.shortName((GraphDatabaseSettings.CypherVersion)v))).collect(Collectors.toList()));
    }
}

