/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.memory;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.util.BaseCoreAPIPath;
import org.neo4j.memory.HeapEstimator;

public class ProcedureHeapEstimator
implements org.neo4j.procedure.memory.HeapEstimator {
    public static final ProcedureHeapEstimator INSTANCE = new ProcedureHeapEstimator();

    private ProcedureHeapEstimator() {
    }

    public long shallowSize(Object o) {
        return Estimations.shallowSize(o);
    }

    public long shallowSizeOfInstance(Class<?> cls) {
        return HeapEstimator.shallowSizeOfInstance(cls);
    }

    public long shallowSizeOfObjectArray(int size) {
        return HeapEstimator.shallowSizeOfObjectArray((int)size);
    }

    public long sizeOfByteArray(int size) {
        return HeapEstimator.sizeOfByteArray((int)size);
    }

    public long sizeOfIntArray(int size) {
        return HeapEstimator.sizeOfIntArray((int)size);
    }

    public long sizeOfLongArray(int size) {
        return HeapEstimator.sizeOfLongArray((int)size);
    }

    public long sizeOfFloatArray(int size) {
        return HeapEstimator.sizeOfFloatArray((int)size);
    }

    public long sizeOfDoubleArray(int size) {
        return HeapEstimator.sizeOfDoubleArray((int)size);
    }

    public static class Estimations {
        private static final long SHALLOW_BASE_CORE_API_SIZE = HeapEstimator.shallowSizeOfInstance(BaseCoreAPIPath.class);

        private Estimations() {
        }

        public static long shallowSize(Object o) {
            if (o instanceof Boolean) {
                return 0L;
            }
            if (o instanceof NodeEntity) {
                return NodeEntity.SHALLOW_SIZE;
            }
            if (o instanceof RelationshipEntity) {
                return RelationshipEntity.SHALLOW_SIZE;
            }
            if (o instanceof BaseCoreAPIPath) {
                BaseCoreAPIPath path = (BaseCoreAPIPath)o;
                return SHALLOW_BASE_CORE_API_SIZE + path.pathValue().estimatedHeapUsage();
            }
            if (o instanceof LocalDate) {
                return HeapEstimator.LOCAL_DATE_SIZE;
            }
            if (o instanceof LocalDateTime) {
                return HeapEstimator.LOCAL_DATE_TIME_SIZE;
            }
            if (o instanceof ZonedDateTime) {
                return HeapEstimator.ZONED_DATE_TIME_SIZE;
            }
            if (o instanceof OffsetTime) {
                return HeapEstimator.OFFSET_TIME_SIZE;
            }
            return HeapEstimator.sizeOf((Object)o);
        }
    }
}

