/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.Cypher5TypeCheckers;

class ProcedureOutputSignatureCompiler {
    private final Cypher5TypeCheckers typeCheckers;

    ProcedureOutputSignatureCompiler(Cypher5TypeCheckers typeCheckers) {
        this.typeCheckers = typeCheckers;
    }

    List<FieldSignature> fieldSignatures(Method method) throws ProcedureException {
        Class<?> cls = method.getReturnType();
        if (cls == Void.class || cls == Void.TYPE) {
            return ProcedureSignature.VOID;
        }
        if (cls != Stream.class) {
            throw ProcedureException.invalidReturnTypeExtended((String)method.getName(), cls);
        }
        Type genericReturnType = method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw ProcedureException.invalidReturnType((String)method.getName(), (String)"raw Stream");
        }
        ParameterizedType genType = (ParameterizedType)genericReturnType;
        Type recordType = genType.getActualTypeArguments()[0];
        if (recordType instanceof WildcardType) {
            throw ProcedureException.invalidReturnType((String)method.getName(), (String)"Stream<?>");
        }
        if (recordType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)recordType;
            throw ProcedureException.invalidReturnType((String)method.getName(), (String)("parameterized type such as " + String.valueOf(type)));
        }
        return this.fieldSignatures(method.getName(), (Class)recordType);
    }

    List<FieldSignature> fieldSignatures(String methodName, Class<?> userClass) throws ProcedureException {
        this.assertIsValidRecordClass(methodName, userClass);
        List<Field> fields = ProcedureOutputSignatureCompiler.instanceFields(userClass);
        FieldSignature[] signature = new FieldSignature[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!userClass.isRecord() && !Modifier.isPublic(field.getModifiers())) {
                throw ProcedureException.unableToAccessField((String)userClass.getSimpleName(), (String)field.getName());
            }
            try {
                Cypher5TypeCheckers.TypeChecker checker = this.typeCheckers.checkerFor(field.getGenericType());
                if (field.isAnnotationPresent(Description.class)) {
                    String description = field.getAnnotation(Description.class).value();
                    signature[i] = FieldSignature.outputField((String)field.getName(), (Neo4jTypes.AnyType)checker.type(), (boolean)field.isAnnotationPresent(Deprecated.class), (String)description);
                    continue;
                }
                signature[i] = FieldSignature.outputField((String)field.getName(), (Neo4jTypes.AnyType)checker.type(), (boolean)field.isAnnotationPresent(Deprecated.class));
                continue;
            }
            catch (ProcedureException e) {
                throw ProcedureException.fieldWithUnsupportedType((String)field.getName(), (String)userClass.getSimpleName(), (ProcedureException)e);
            }
        }
        return Arrays.asList(signature);
    }

    private void assertIsValidRecordClass(String methodName, Class<?> userClass) throws ProcedureException {
        if (userClass.isPrimitive() || userClass.isArray() || userClass.getPackage() != null && userClass.getPackage().getName().startsWith("java.")) {
            throw ProcedureException.invalidReturnTypeExtended((String)methodName, userClass);
        }
    }

    static List<Field> instanceFields(Class<?> userClass) {
        return Stream.iterate(userClass, Predicate.not(ProcedureOutputSignatureCompiler::isJavaLangClass), Class::getSuperclass).flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.isSynthetic()).toList();
    }

    private static boolean isJavaLangClass(Class<?> cls) {
        return cls.getPackage().getName().equals("java.lang");
    }
}

