/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

public final class QueryId {
    public static final String PREFIX = "query-";
    private static final String EXPECTED_FORMAT = "query-<id>";
    private static final String EXPECTED_FORMAT_MSG = "(expected format: %s)".formatted("query-<id>");

    private QueryId() {
    }

    public static long parse(String queryIdText, String argumentName, String procedureName) throws InvalidArgumentsException {
        try {
            if (!queryIdText.startsWith(PREFIX)) {
                throw InvalidArgumentsException.invalidProcedureArgument((String)queryIdText, (String)argumentName, (String)procedureName, (String)EXPECTED_FORMAT, (String)"Expected prefix query-", null);
            }
            String qid = queryIdText.substring(PREFIX.length());
            long internalId = Long.parseLong(qid);
            if (internalId <= 0L) {
                throw InvalidArgumentsException.invalidProcedureArgument((String)queryIdText, (String)argumentName, (String)procedureName, (String)EXPECTED_FORMAT, (String)("Negative ids are not supported " + EXPECTED_FORMAT_MSG), null);
            }
            return internalId;
        }
        catch (Exception e) {
            if (e instanceof InvalidArgumentsException) {
                InvalidArgumentsException iae = (InvalidArgumentsException)e;
                throw iae;
            }
            throw InvalidArgumentsException.invalidProcedureArgument((String)queryIdText, (String)argumentName, (String)procedureName, (String)EXPECTED_FORMAT, (String)("Could not parse id " + queryIdText + " " + EXPECTED_FORMAT_MSG), (Throwable)e);
        }
    }
}

