/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.ComponentInjectionException;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.FieldSetter;

class FieldInjections {
    private final ComponentRegistry components;

    FieldInjections(ComponentRegistry components) {
        this.components = components;
    }

    List<FieldSetter> setters(Class<?> cls) throws ProcedureException {
        LinkedList<FieldSetter> setters = new LinkedList<FieldSetter>();
        Class<?> currentClass = cls;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    if (!field.isAnnotationPresent(Context.class)) continue;
                    throw ProcedureException.faultyClassFieldAnnotationStatic((String)field.getName(), (String)cls.getSimpleName());
                }
                FieldInjections.assertValidForInjection(cls, field);
                setters.add(this.createInjector(cls, field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return setters;
    }

    private FieldSetter createInjector(Class<?> cls, Field field) throws ProcedureException {
        ThrowingFunction<org.neo4j.kernel.api.procedure.Context, ?, ProcedureException> provider = this.components.providerFor(field.getType());
        if (provider == null) {
            throw ComponentInjectionException.unsupportedInjectableComponentType((String)cls.getSimpleName(), (String)field.getName(), (String)String.valueOf(field.getType()));
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw ProcedureException.unableToAccessFieldInjection((String)cls.getSimpleName(), (String)field.getName());
        }
        return new FieldSetter(field, provider);
    }

    private static void assertValidForInjection(Class<?> cls, Field field) throws ProcedureException {
        if (!field.isAnnotationPresent(Context.class)) {
            throw ProcedureException.missingClassFieldAnnotation((String)cls.getSimpleName(), (String)field.getName());
        }
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
            throw ProcedureException.faultyClassFieldAnnotation((String)cls.getSimpleName(), (String)field.getName());
        }
    }
}

