/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.Arrays;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceUtils;

public class PrimitiveLongResourceCollections {
    private static final PrimitiveLongResourceIterator EMPTY = new PrimitiveLongBaseResourceIterator(null){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    public static PrimitiveLongResourceIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveLongResourceIterator iterator(Resource resource, long ... items) {
        return PrimitiveLongCollections.resourceIterator(PrimitiveLongCollections.iterator(items), resource);
    }

    public static PrimitiveLongResourceIterator concat(PrimitiveLongResourceIterator ... primitiveLongResourceIterators) {
        return PrimitiveLongResourceCollections.concat(Arrays.asList(primitiveLongResourceIterators));
    }

    public static PrimitiveLongResourceIterator concat(Iterable<PrimitiveLongResourceIterator> primitiveLongResourceIterators) {
        return new PrimitiveLongConcatingResourceIterator(primitiveLongResourceIterators);
    }

    public static PrimitiveLongResourceIterator filter(PrimitiveLongResourceIterator source, final LongPredicate filter) {
        return new PrimitiveLongFilteringResourceIterator(source){

            @Override
            public boolean test(long item) {
                return filter.test(item);
            }
        };
    }

    private static abstract class PrimitiveLongFilteringResourceIterator
    extends PrimitiveLongBaseResourceIterator
    implements LongPredicate {
        private final PrimitiveLongIterator source;

        private PrimitiveLongFilteringResourceIterator(PrimitiveLongResourceIterator source) {
            super(source);
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                long testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(long var1);
    }

    private static class PrimitiveLongConcatingResourceIterator
    extends PrimitiveLongCollections.PrimitiveLongConcatingIterator
    implements PrimitiveLongResourceIterator {
        private final Iterable<PrimitiveLongResourceIterator> iterators;
        private volatile boolean closed;

        private PrimitiveLongConcatingResourceIterator(Iterable<PrimitiveLongResourceIterator> iterators) {
            super(iterators.iterator());
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            return !this.closed && super.fetchNext();
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                ResourceUtils.closeAll(this.iterators);
            }
        }
    }

    static abstract class PrimitiveLongBaseResourceIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements PrimitiveLongResourceIterator {
        private Resource resource;

        PrimitiveLongBaseResourceIterator(Resource resource) {
            this.resource = resource;
        }

        public void close() {
            if (this.resource != null) {
                this.resource.close();
                this.resource = null;
            }
        }
    }
}

