/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongToIntFunction;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.base.Empty;

public class PrimitiveIntCollections {
    private static final PrimitiveIntIterator EMPTY = new PrimitiveIntBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    private PrimitiveIntCollections() {
    }

    public static PrimitiveIntIterator iterator(final int ... items) {
        return new PrimitiveIntBaseIterator(){
            private int index = -1;

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveIntIterator concat(Iterator<PrimitiveIntIterator> iterators) {
        return new PrimitiveIntConcatingIterator(iterators);
    }

    public static PrimitiveIntIterator filter(PrimitiveIntIterator source, final IntPredicate filter) {
        return new PrimitiveIntFilteringIterator(source){

            @Override
            public boolean test(int item) {
                return filter.test(item);
            }
        };
    }

    public static PrimitiveIntIterator deduplicate(PrimitiveIntIterator source) {
        return new PrimitiveIntFilteringIterator(source){
            private final PrimitiveIntSet visited = Primitive.intSet();

            @Override
            public boolean test(int testItem) {
                return this.visited.add(testItem);
            }
        };
    }

    public static PrimitiveIntSet asSet(PrimitiveIntIterator iterator) {
        PrimitiveIntSet set = Primitive.intSet();
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (set.add(next)) continue;
            throw new IllegalStateException("Duplicate " + next + " from " + iterator);
        }
        return set;
    }

    public static long[] asLongArray(PrimitiveIntCollection values) {
        long[] array = new long[values.size()];
        PrimitiveIntIterator iterator = values.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = iterator.next();
        }
        return array;
    }

    public static PrimitiveIntIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveIntSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_INT_SET;
    }

    public static PrimitiveIntIterator toPrimitiveIterator(final Iterator<Integer> iterator) {
        return new PrimitiveIntBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    Integer nextValue = (Integer)iterator.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Integer to primitive int");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static <T> Iterator<T> map(final IntFunction<T> mapFunction, final PrimitiveIntIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void consume(PrimitiveIntIterator source, IntConsumer consumer) {
        while (source.hasNext()) {
            consumer.accept(source.next());
        }
    }

    public static PrimitiveIntSet asSet(int[] values) {
        PrimitiveIntSet set = Primitive.intSet(values.length);
        for (int value : values) {
            set.add(value);
        }
        return set;
    }

    public static PrimitiveIntSet asSet(long[] values, LongToIntFunction converter) {
        PrimitiveIntSet set = Primitive.intSet(values.length);
        for (long value : values) {
            set.add(converter.applyAsInt(value));
        }
        return set;
    }

    public static <T> PrimitiveIntObjectMap<T> copyTransform(PrimitiveIntObjectMap<T> original, Function<T, T> transform) {
        PrimitiveIntObjectMap copy = Primitive.intObjectMap(original.size());
        original.visitEntries((key, value) -> {
            copy.put(key, transform.apply(value));
            return false;
        });
        return copy;
    }

    public static boolean contains(int[] values, int candidate) {
        for (int value : values) {
            if (value != candidate) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> toList(PrimitiveIntIterator iterator) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static Set<Integer> toSet(PrimitiveIntIterator iterator) {
        return PrimitiveIntCollections.mapToSet(iterator, Integer::new);
    }

    public static <T> Set<T> mapToSet(PrimitiveIntIterator iterator, IntFunction<T> map) {
        HashSet set = new HashSet();
        while (iterator.hasNext()) {
            PrimitiveIntCollections.addUnique(set, map.apply(iterator.next()));
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static int[] deduplicate(int[] values) {
        int unique = 0;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            for (int j = 0; j < unique; ++j) {
                if (value != values[j]) continue;
                value = -1;
                break;
            }
            if (value == -1) continue;
            values[unique++] = values[i];
        }
        return unique < values.length ? Arrays.copyOf(values, unique) : values;
    }

    public static abstract class PrimitiveIntFilteringIterator
    extends PrimitiveIntBaseIterator
    implements IntPredicate {
        private final PrimitiveIntIterator source;

        public PrimitiveIntFilteringIterator(PrimitiveIntIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                int testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(int var1);
    }

    public static class PrimitiveIntConcatingIterator
    extends PrimitiveIntBaseIterator {
        private final Iterator<PrimitiveIntIterator> iterators;
        private PrimitiveIntIterator currentIterator;

        public PrimitiveIntConcatingIterator(Iterator<PrimitiveIntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() && this.next(this.currentIterator.next());
        }

        protected final PrimitiveIntIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveIntBaseIterator
    implements PrimitiveIntIterator {
        private boolean hasNextDecided;
        private boolean hasNext;
        private int next;

        @Override
        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(int nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

