/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import org.neo4j.collection.primitive.hopscotch.IntArrayBasedKeyTable;

public class VersionedLongKeyTable<VALUE>
extends IntArrayBasedKeyTable<VALUE> {
    private int version;

    public VersionedLongKeyTable(int h, VALUE singleValue) {
        super(4, h, singleValue);
    }

    public VersionedLongKeyTable(int capacity, int h, VALUE singleValue, int version) {
        super(capacity, 4, h, singleValue);
        this.version = version;
    }

    @Override
    public long key(int index) {
        int actualIndex = this.index(index);
        return (long)this.table[actualIndex] | (long)(this.table[actualIndex + 1] << 32);
    }

    @Override
    protected void internalPut(int actualIndex, long key, VALUE value) {
        this.table[actualIndex] = (int)key;
        this.table[actualIndex + 1] = (int)((key & 0xFFFFFFFF00000000L) >>> 32);
        this.table[actualIndex + 2] = this.version;
    }

    @Override
    protected void internalRemove(int actualIndex) {
        Arrays.fill(this.table, actualIndex, actualIndex + 2, -1);
    }

    @Override
    protected VersionedLongKeyTable<VALUE> newInstance(int newCapacity) {
        return new VersionedLongKeyTable<Object>(newCapacity, this.h, this.singleValue, this.version);
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public int version(int index) {
        return this.table[this.index(index) + 2];
    }
}

