/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.quarkus.runtime;

import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import org.neo4j.driver.Driver;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.quarkus.runtime.Neo4jOgmProperties;
import org.neo4j.ogm.session.SessionFactory;

@Recorder
public class Neo4jOgmRecorder {
    public RuntimeValue<SessionFactory> initializeSessionFactory(RuntimeValue<Driver> driverRuntimeValue, ShutdownContext shutdownContext, Neo4jConfiguration neo4jConfiguration, Neo4jOgmProperties ogmProperties, String[] allPackages) {
        Configuration.Builder builder = new Configuration.Builder().uri(neo4jConfiguration.uri);
        ogmProperties.database.ifPresent(arg_0 -> ((Configuration.Builder)builder).database(arg_0));
        if (ogmProperties.useNativeTypes) {
            builder.useNativeTypes();
        }
        if (ogmProperties.useStrictQuerying) {
            builder.strictQuerying();
        }
        builder.withBasePackages(allPackages);
        org.neo4j.ogm.driver.Driver driver = this.createConfigurableDriver(driverRuntimeValue);
        driver.configure(builder.build());
        SessionFactory sessionFactory = new SessionFactory(driver, allPackages);
        shutdownContext.addLastShutdownTask(() -> ((SessionFactory)sessionFactory).close());
        return new RuntimeValue((Object)sessionFactory);
    }

    private org.neo4j.ogm.driver.Driver createConfigurableDriver(RuntimeValue<Driver> driverRuntimeValue) {
        return new BoltDriver((Driver)driverRuntimeValue.getValue()){

            public synchronized void close() {
            }
        };
    }
}

