/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.response.model.QueryStatisticsModel;

public abstract class AbstractHttpResponse<T>
implements AutoCloseable {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private final Class<T> resultClass;
    private final String[] columns;
    private final QueryStatistics queryStatistics;
    private final ResultNodeIterator results;

    AbstractHttpResponse(CloseableHttpResponse httpResponse, Class<T> resultClass) {
        this(httpResponse, resultClass, true);
    }

    AbstractHttpResponse(CloseableHttpResponse httpResponse, Class<T> resultClass, boolean flatMapData) {
        this.resultClass = resultClass;
        try (CloseableHttpResponse httpResponseToClose = httpResponse;
             InputStream inputStreamOfResponse = httpResponseToClose.getEntity().getContent();
             TokenBuffer bufferedResponse = this.createTokenBuffer(inputStreamOfResponse);){
            JsonParser pointingOnErrors = AbstractHttpResponse.findNextObject(bufferedResponse.asParserOnFirstToken(), "errors");
            this.throwExceptionOnErrorEntry(pointingOnErrors);
            JsonParser unbufferedResults = AbstractHttpResponse.findNextObject(bufferedResponse.asParserOnFirstToken(), "results");
            AbstractHttpResponse.throwExceptionOnIncorrectResultEntry(unbufferedResults);
            TokenBuffer resultBuffer = this.createTokenBuffer(unbufferedResults);
            this.columns = this.readColumns(resultBuffer);
            this.queryStatistics = this.readQueryStatistics(resultBuffer);
            this.results = new ResultNodeIterator(this.mapper, resultBuffer.asParserOnFirstToken(), flatMapData);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TokenBuffer createTokenBuffer(InputStream inputStream) throws IOException {
        try (JsonParser jsonParser = JSON_FACTORY.createParser(inputStream);){
            jsonParser.nextToken();
            TokenBuffer tokenBuffer = this.createTokenBuffer(jsonParser);
            return tokenBuffer;
        }
    }

    private TokenBuffer createTokenBuffer(JsonParser jsonParser) throws IOException {
        TokenBuffer tokenBuffer = new TokenBuffer((ObjectCodec)this.mapper, true);
        tokenBuffer.copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    private static JsonParser findNextObject(JsonParser parser, String nodeName) throws IOException {
        JsonToken jsonToken;
        while ((jsonToken = parser.nextToken()) != null) {
            parser.skipChildren();
            if (!JsonToken.FIELD_NAME.equals((Object)jsonToken) || !parser.getCurrentName().equals(nodeName)) continue;
            parser.nextToken();
            return parser;
        }
        return null;
    }

    private void throwExceptionOnErrorEntry(JsonParser pointingToErrors) throws IOException {
        if (pointingToErrors == null) {
            return;
        }
        JsonNode errorsNode = (JsonNode)this.mapper.readTree(pointingToErrors);
        Optional optionalErrorNode = StreamSupport.stream(errorsNode.spliterator(), false).findFirst();
        if (optionalErrorNode.isPresent()) {
            JsonNode errorNode = (JsonNode)optionalErrorNode.get();
            throw new CypherException(errorNode.findValue("code").asText(), errorNode.findValue("message").asText());
        }
    }

    private static void throwExceptionOnIncorrectResultEntry(JsonParser pointingToResults) throws IOException {
        if (pointingToResults == null) {
            throw new IOException("Response doesn't contain any results.");
        }
        if (!JsonToken.START_ARRAY.equals((Object)pointingToResults.currentToken())) {
            throw new IOException("Current result object is not an array!");
        }
    }

    private String[] readColumns(TokenBuffer bufferedResults) throws IOException {
        JsonParser parser = bufferedResults.asParserOnFirstToken();
        parser.nextToken();
        parser = AbstractHttpResponse.findNextObject(parser, "columns");
        if (parser == null) {
            return new String[0];
        }
        return (String[])this.mapper.readValue(parser, String[].class);
    }

    private QueryStatistics readQueryStatistics(TokenBuffer bufferedResults) throws IOException {
        JsonParser parser = bufferedResults.asParserOnFirstToken();
        parser.nextToken();
        parser = AbstractHttpResponse.findNextObject(parser, "stats");
        if (parser != null) {
            return (QueryStatistics)this.mapper.readValue(parser, QueryStatisticsModel.class);
        }
        return null;
    }

    T nextDataRecord(String key) {
        try {
            if (this.results.hasNext()) {
                JsonNode dataNode = this.results.next();
                Object t = dataNode.has(key) ? this.mapper.treeToValue((TreeNode)dataNode.get(key), this.resultClass) : null;
                return (T)t;
            }
        }
        catch (IOException e) {
            throw new ResultProcessingException("Error processing results", (Exception)e);
        }
        return null;
    }

    public String[] columns() {
        return this.columns;
    }

    QueryStatistics statistics() {
        return this.queryStatistics;
    }

    @Override
    public void close() {
        try {
            this.results.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class ResultNodeIterator
    implements Iterator<JsonNode>,
    AutoCloseable {
        private final ObjectMapper objectMapper;
        private final JsonParser results;
        private final boolean flatMapData;
        private Iterator<JsonNode> currentDataNodes;

        ResultNodeIterator(ObjectMapper objectMapper, JsonParser results, boolean flatMapData) {
            this.objectMapper = objectMapper;
            this.results = results;
            this.flatMapData = flatMapData;
        }

        @Override
        public boolean hasNext() {
            boolean moreDataNodes = this.currentDataNodes != null && this.currentDataNodes.hasNext();
            try {
                while (!moreDataNodes && this.results.nextToken() != JsonToken.END_ARRAY) {
                    JsonNode resultNode = (JsonNode)this.objectMapper.readTree(this.results);
                    if (!this.flatMapData) {
                        this.currentDataNodes = Collections.singletonList(resultNode).iterator();
                    } else {
                        JsonNode dataArrayNode = resultNode.get("data");
                        if (dataArrayNode != null && dataArrayNode.isArray()) {
                            this.currentDataNodes = dataArrayNode.iterator();
                        }
                    }
                    moreDataNodes = this.currentDataNodes.hasNext();
                }
            }
            catch (IOException e) {
                moreDataNodes = false;
            }
            return moreDataNodes;
        }

        @Override
        public JsonNode next() {
            return this.currentDataNodes.next();
        }

        @Override
        public void close() throws IOException {
            this.results.close();
        }
    }
}

