/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.neo4j.ogm.authentication.Credentials;
import org.neo4j.ogm.drivers.http.request.HttpAuthorization;
import org.neo4j.ogm.drivers.http.request.HttpRequestException;
import org.neo4j.ogm.drivers.http.response.GraphModelResponse;
import org.neo4j.ogm.drivers.http.response.GraphRowsModelResponse;
import org.neo4j.ogm.drivers.http.response.RestModelResponse;
import org.neo4j.ogm.drivers.http.response.RowModelResponse;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.json.ObjectMapperFactory;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.Statements;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
implements Request {
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private final String url;
    private final CloseableHttpClient httpClient;
    private final Credentials credentials;
    private final boolean readOnly;

    public HttpRequest(CloseableHttpClient httpClient, String url, Credentials credentials) {
        this(httpClient, url, credentials, false);
    }

    public HttpRequest(CloseableHttpClient httpClient, String url, Credentials credentials, boolean readOnly) {
        this.httpClient = httpClient;
        this.url = url;
        this.credentials = credentials;
        this.readOnly = readOnly;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        return new GraphModelResponse(this.executeRequest(cypher));
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        return new RowModelResponse(this.executeRequest(cypher));
    }

    public Response<RowModel> execute(DefaultRequest query) {
        Statements statements = new Statements(query.getStatements());
        String cypher = this.cypherRequest(statements);
        return new RowModelResponse(this.executeRequest(cypher));
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        return new GraphRowsModelResponse(this.executeRequest(cypher));
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        String cypher = this.cypherRequest((Statement)request);
        return new RestModelResponse(this.executeRequest(cypher));
    }

    private String cypherRequest(Statement statement) {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        statementList.add(statement);
        try {
            return mapper.writeValueAsString((Object)new Statements(statementList));
        }
        catch (JsonProcessingException jpe) {
            throw new ResultProcessingException("Could not create JSON due to " + jpe.getLocalizedMessage(), (Exception)((Object)jpe));
        }
    }

    private String cypherRequest(Statements statements) {
        try {
            return mapper.writeValueAsString((Object)statements);
        }
        catch (JsonProcessingException jpe) {
            throw new ResultProcessingException("Could not create JSON due to " + jpe.getLocalizedMessage(), (Exception)((Object)jpe));
        }
    }

    private CloseableHttpResponse executeRequest(String cypher) throws HttpRequestException {
        String url = this.url;
        assert (url != null);
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)new StringEntity(cypher, "UTF-8"));
        request.setHeader("X-WRITE", this.readOnly ? "0" : "1");
        logger.info("Thread: {}, url: {}, request: {}", new Object[]{Thread.currentThread().getId(), url, cypher});
        return HttpRequest.execute(this.httpClient, (HttpRequestBase)request, this.credentials);
    }

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase request, Credentials credentials) throws HttpRequestException {
        logger.debug("Thread: {}, request: {}", (Object)Thread.currentThread().getId(), (Object)request);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
        request.setHeader((Header)new BasicHeader("User-Agent", "neo4j-ogm.java/2.0"));
        request.setHeader((Header)new BasicHeader("Accept", "application/json;charset=UTF-8"));
        HttpAuthorization.authorize(request, credentials);
        RetryOnExceptionStrategy retryStrategy = new RetryOnExceptionStrategy();
        while (retryStrategy.shouldRetry()) {
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                StatusLine statusLine = response.getStatusLine();
                HttpEntity responseEntity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    String responseText = statusLine.getReasonPhrase();
                    if (responseEntity != null) {
                        responseText = HttpRequest.parseError(EntityUtils.toString((HttpEntity)responseEntity));
                        logger.warn("Thread: {}, response: {}", (Object)Thread.currentThread().getId(), (Object)responseText);
                    }
                    throw new HttpResponseException(statusLine.getStatusCode(), responseText);
                }
                if (responseEntity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                return response;
            }
            catch (NoHttpResponseException nhre) {
                logger.warn("Thread: {}, No response from server:  Retrying in {} milliseconds, retries left: {}", new Object[]{Thread.currentThread().getId(), retryStrategy.getTimeToWait(), retryStrategy.numberOfTriesLeft});
                retryStrategy.errorOccured();
            }
            catch (RetryException re) {
                throw new HttpRequestException(request, re);
            }
            catch (ClientProtocolException uhe) {
                throw new ConnectionException(request.getURI().toString(), (Throwable)uhe);
            }
            catch (IOException ioe) {
                throw new HttpRequestException(request, ioe);
            }
            catch (Exception exception) {
                logger.warn("Thread: {}, exception: {}", (Object)Thread.currentThread().getId(), (Object)exception.getCause().getLocalizedMessage());
                request.releaseConnection();
                throw exception;
            }
        }
        throw new RuntimeException("Fatal Exception: Should not have occurred!");
    }

    private static String parseError(String results) {
        try {
            ObjectMapper mapper = ObjectMapperFactory.objectMapper();
            JsonNode responseNode = mapper.readTree(results);
            JsonNode errors = responseNode.findValue("errors");
            if (errors.elements().hasNext()) {
                JsonNode errorNode = (JsonNode)errors.elements().next();
                return errorNode.findValue("message").asText();
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class RetryException
    extends RuntimeException {
        public RetryException(String msg) {
            super(msg);
        }
    }

    static class RetryOnExceptionStrategy {
        public static final int DEFAULT_RETRIES = 3;
        public static final long DEFAULT_WAIT_TIME_IN_MILLI = 2000L;
        private int numberOfRetries;
        private int numberOfTriesLeft;
        private long timeToWait;

        public RetryOnExceptionStrategy() {
            this(3, 2000L);
        }

        public RetryOnExceptionStrategy(int numberOfRetries, long timeToWait) {
            this.numberOfRetries = numberOfRetries;
            this.numberOfTriesLeft = numberOfRetries;
            this.timeToWait = timeToWait;
        }

        public boolean shouldRetry() {
            return this.numberOfTriesLeft > 0;
        }

        public void errorOccured() {
            --this.numberOfTriesLeft;
            if (!this.shouldRetry()) {
                throw new RetryException("Retry Failed: Total " + this.numberOfRetries + " attempts made at interval " + this.getTimeToWait() + "ms");
            }
            this.waitUntilNextTry();
        }

        public long getTimeToWait() {
            return this.timeToWait;
        }

        private void waitUntilNextTry() {
            try {
                Thread.sleep(this.getTimeToWait());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

