/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.ogm.driver.TypeSystem;

public class EmbeddedEntityAdapter {
    private final TypeSystem typeSystem;
    private volatile Optional<Object> noValue;

    EmbeddedEntityAdapter(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    public boolean isPath(Object value) {
        return value instanceof Path;
    }

    public boolean isNode(Object value) {
        return value instanceof Node;
    }

    public boolean isRelationship(Object value) {
        return value instanceof Relationship;
    }

    public long nodeId(Object node) {
        return ((Node)node).getId();
    }

    public List<String> labels(Object node) {
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : ((Node)node).getLabels()) {
            labels.add(label.name());
        }
        return labels;
    }

    public long relationshipId(Object relationship) {
        return ((Relationship)relationship).getId();
    }

    public String relationshipType(Object relationship) {
        return ((Relationship)relationship).getType().name();
    }

    public Long startNodeId(Object relationship) {
        return ((Relationship)relationship).getStartNode().getId();
    }

    public Long endNodeId(Object relationship) {
        return ((Relationship)relationship).getEndNode().getId();
    }

    public Map<String, Object> properties(Object container) {
        return this.getAllProperties((PropertyContainer)container);
    }

    public List<Object> nodesInPath(Object path) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Node node : ((Path)path).nodes()) {
            nodes.add(node);
        }
        return nodes;
    }

    public List<Object> relsInPath(Object path) {
        ArrayList<Object> rels = new ArrayList<Object>();
        for (Relationship rel : ((Path)path).relationships()) {
            rels.add(rel);
        }
        return rels;
    }

    public Map<String, Object> getAllProperties(PropertyContainer propertyContainer) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : propertyContainer.getPropertyKeys()) {
            properties.put(key, this.toMapped(propertyContainer.getProperty(key)));
        }
        return properties;
    }

    private Object toMapped(Object value) {
        if (value == null || value == this.getNoValue()) {
            return null;
        }
        if (value.getClass().isArray()) {
            return this.arrayToMapped(value);
        }
        return this.typeSystem.getNativeToMappedTypeAdapter(value.getClass()).apply(value);
    }

    private Object arrayToMapped(Object array) {
        Function nativeToMappedTypeAdapter = this.typeSystem.getNativeToMappedTypeAdapter(array.getClass().getComponentType());
        int length = Array.getLength(array);
        Object[] newArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object object = Array.get(array, i);
            newArray[i] = nativeToMappedTypeAdapter.apply(object);
        }
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNoValue() {
        Optional<Object> loadedCypherModification = this.noValue;
        if (loadedCypherModification == null) {
            EmbeddedEntityAdapter embeddedEntityAdapter = this;
            synchronized (embeddedEntityAdapter) {
                loadedCypherModification = this.noValue;
                if (loadedCypherModification == null) {
                    loadedCypherModification = this.noValue = Optional.ofNullable(EmbeddedEntityAdapter.getNoValueImpl());
                }
            }
        }
        return loadedCypherModification;
    }

    private static Object getNoValueImpl() {
        try {
            Class<?> clazz = Class.forName("org.neo4j.values.storable.Values");
            Field noValueField = clazz.getField("NO_VALUE");
            return noValueField.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

