/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoltResponse<T>
implements Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltResponse.class);
    private static final Logger cypherPerformanceNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.performance");
    private static final Logger cypherHintNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.hint");
    private static final Logger cypherUnrecognizedNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.unrecognized");
    private static final Logger cypherUnsupportedNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.unsupported");
    private static final Logger cypherDeprecationNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.deprecation");
    private static final Logger cypherGenericNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.generic");
    private static final Logger cypherSecurityNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.security");
    private static final Logger cypherTopologyNotificationLog = LoggerFactory.getLogger((String)"org.neo4j.ogm.drivers.bolt.response.BoltResponse.topology");
    protected final Result result;
    private static final String LINE_SEPARATOR = System.lineSeparator();

    BoltResponse(Result result) {
        this.result = result;
    }

    public T next() {
        try {
            return this.fetchNext();
        }
        catch (ClientException ce) {
            LOGGER.debug("Error executing Cypher: {}, {}", (Object)ce.code(), (Object)ce.getMessage());
            throw new CypherException(ce.code(), ce.getMessage(), (Throwable)ce);
        }
    }

    protected abstract T fetchNext();

    public void close() {
        ResultSummary summary = this.result.consume();
        BoltResponse.process(summary);
    }

    public String[] columns() {
        Record record;
        if (this.result.hasNext() && (record = this.result.peek()) != null) {
            Set columns = this.result.peek().asMap().keySet();
            return columns.toArray(new String[columns.size()]);
        }
        return new String[0];
    }

    static ResultSummary process(ResultSummary resultSummary) {
        BoltResponse.logNotifications(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        if (resultSummary.notifications().isEmpty() || !LOGGER.isWarnEnabled()) {
            return;
        }
        String query = resultSummary.query().text();
        resultSummary.notifications().forEach(notification -> {
            Logger logger = notification.category().map(BoltResponse::getLogger).orElse(LOGGER);
            (switch (notification.severity()) {
                case "WARNING" -> arg_0 -> ((Logger)logger).warn(arg_0);
                case "INFORMATION" -> arg_0 -> ((Logger)logger).info(arg_0);
                default -> arg_0 -> ((Logger)logger).debug(arg_0);
            }).accept(BoltResponse.format(notification, query));
        });
    }

    private static Logger getLogger(NotificationCategory category) {
        if (category == NotificationCategory.HINT) {
            return cypherHintNotificationLog;
        }
        if (category == NotificationCategory.DEPRECATION) {
            return cypherDeprecationNotificationLog;
        }
        if (category == NotificationCategory.PERFORMANCE) {
            return cypherPerformanceNotificationLog;
        }
        if (category == NotificationCategory.GENERIC) {
            return cypherGenericNotificationLog;
        }
        if (category == NotificationCategory.UNSUPPORTED) {
            return cypherUnsupportedNotificationLog;
        }
        if (category == NotificationCategory.UNRECOGNIZED) {
            return cypherUnrecognizedNotificationLog;
        }
        if (category == NotificationCategory.SECURITY) {
            return cypherSecurityNotificationLog;
        }
        if (category == NotificationCategory.TOPOLOGY) {
            return cypherTopologyNotificationLog;
        }
        return LOGGER;
    }

    private static String format(Notification notification, String forQuery) {
        InputPosition position = notification.position();
        int lineNumber = position != null ? position.line() : 1;
        int column = position != null ? position.column() : 1;
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (i + 1 != lineNumber) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(column - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s: %s%n%s%s", notification.code(), notification.title(), queryHint, notification.description());
    }
}

