/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.types;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.neo4j.ogm.driver.TypeAdapterLookupDelegate;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.drivers.bolt.types.adapter.BoltValueToPointAdapter;
import org.neo4j.ogm.drivers.bolt.types.adapter.PointToBoltValueAdapter;
import org.neo4j.ogm.types.adapter.TemporalAmountAdapter;
import org.neo4j.ogm.types.spatial.CartesianPoint2d;
import org.neo4j.ogm.types.spatial.CartesianPoint3d;
import org.neo4j.ogm.types.spatial.GeographicPoint2d;
import org.neo4j.ogm.types.spatial.GeographicPoint3d;

class BoltNativeTypes
implements TypeSystem {
    private final TypeAdapterLookupDelegate nativeToMappedAdapter;
    private final TypeAdapterLookupDelegate mappedToNativeAdapter;

    BoltNativeTypes() {
        HashMap mapOfNativeToMappedAdapter = new HashMap();
        HashMap mapOfMappedToNativeAdapter = new HashMap();
        BoltNativeTypes.addSpatialFeatures(mapOfNativeToMappedAdapter, mapOfMappedToNativeAdapter);
        BoltNativeTypes.addJavaTimeFeature(mapOfNativeToMappedAdapter, mapOfMappedToNativeAdapter);
        BoltNativeTypes.addPassthroughForBuildInTypes(mapOfMappedToNativeAdapter);
        this.nativeToMappedAdapter = new TypeAdapterLookupDelegate(mapOfNativeToMappedAdapter);
        this.mappedToNativeAdapter = new TypeAdapterLookupDelegate(mapOfMappedToNativeAdapter);
    }

    private static void addSpatialFeatures(Map<Class<?>, Function> nativeToMappedAdapter, Map<Class<?>, Function> mappedToNativeAdapter) {
        nativeToMappedAdapter.put(Point.class, new BoltValueToPointAdapter());
        PointToBoltValueAdapter pointToBoltValueAdapter = new PointToBoltValueAdapter();
        mappedToNativeAdapter.put(CartesianPoint2d.class, pointToBoltValueAdapter);
        mappedToNativeAdapter.put(CartesianPoint3d.class, pointToBoltValueAdapter);
        mappedToNativeAdapter.put(GeographicPoint2d.class, pointToBoltValueAdapter);
        mappedToNativeAdapter.put(GeographicPoint3d.class, pointToBoltValueAdapter);
    }

    private static void addJavaTimeFeature(Map<Class<?>, Function> nativeToMappedAdapter, Map<Class<?>, Function> mappedToNativeAdapter) {
        nativeToMappedAdapter.put(DateValue.class, Values.ofLocalDate());
        nativeToMappedAdapter.put(TimeValue.class, Values.ofOffsetTime());
        nativeToMappedAdapter.put(LocalTimeValue.class, Values.ofLocalTime());
        nativeToMappedAdapter.put(DateTimeValue.class, Values.ofZonedDateTime());
        nativeToMappedAdapter.put(LocalDateTimeValue.class, Values.ofLocalDateTime());
        nativeToMappedAdapter.put(IsoDuration.class, (Function)new TemporalAmountAdapter());
        mappedToNativeAdapter.put(LocalDate.class, Values::value);
        mappedToNativeAdapter.put(OffsetTime.class, Values::value);
        mappedToNativeAdapter.put(LocalTime.class, Values::value);
        mappedToNativeAdapter.put(ZonedDateTime.class, Values::value);
        mappedToNativeAdapter.put(LocalDateTime.class, Values::value);
        mappedToNativeAdapter.put(Duration.class, Values::value);
        mappedToNativeAdapter.put(Period.class, Values::value);
        mappedToNativeAdapter.put(TemporalAmount.class, Values::value);
    }

    private static void addPassthroughForBuildInTypes(Map<Class<?>, Function> mappedToNativeAdapter) {
        mappedToNativeAdapter.put(PointValue.class, Function.identity());
        mappedToNativeAdapter.put(DateValue.class, Function.identity());
        mappedToNativeAdapter.put(TimeValue.class, Function.identity());
        mappedToNativeAdapter.put(LocalTimeValue.class, Function.identity());
        mappedToNativeAdapter.put(DateTimeValue.class, Function.identity());
        mappedToNativeAdapter.put(LocalDateTimeValue.class, Function.identity());
        mappedToNativeAdapter.put(DurationValue.class, Function.identity());
    }

    public boolean supportsAsNativeType(Class<?> clazz) {
        return super.supportsAsNativeType(clazz) || this.mappedToNativeAdapter.hasAdapterFor(clazz);
    }

    public Function<Object, Object> getNativeToMappedTypeAdapter(Class<?> clazz) {
        return this.nativeToMappedAdapter.getAdapterFor(clazz);
    }

    public Function<Object, Object> getMappedToNativeTypeAdapter(Class<?> clazz) {
        return this.mappedToNativeAdapter.getAdapterFor(clazz);
    }
}

