/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoltResponse<T>
implements Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltResponse.class);
    protected final Result result;
    private static final String LINE_SEPARATOR = System.lineSeparator();

    BoltResponse(Result result) {
        this.result = result;
    }

    public T next() {
        try {
            return this.fetchNext();
        }
        catch (ClientException ce) {
            LOGGER.debug("Error executing Cypher: {}, {}", (Object)ce.code(), (Object)ce.getMessage());
            throw new CypherException(ce.code(), ce.getMessage(), (Throwable)ce);
        }
    }

    protected abstract T fetchNext();

    public void close() {
        ResultSummary summary = this.result.consume();
        BoltResponse.process(summary);
    }

    public String[] columns() {
        Record record;
        if (this.result.hasNext() && (record = this.result.peek()) != null) {
            Set columns = this.result.peek().asMap().keySet();
            return columns.toArray(new String[columns.size()]);
        }
        return new String[0];
    }

    static ResultSummary process(ResultSummary resultSummary) {
        BoltResponse.logNotifications(resultSummary);
        return resultSummary;
    }

    private static void logNotifications(ResultSummary resultSummary) {
        if (resultSummary.notifications().isEmpty() || !LOGGER.isWarnEnabled()) {
            return;
        }
        String query = resultSummary.query().text();
        resultSummary.notifications().forEach(notification -> (switch (notification.severity()) {
            case "WARNING" -> arg_0 -> ((Logger)LOGGER).warn(arg_0);
            case "INFORMATION" -> arg_0 -> ((Logger)LOGGER).info(arg_0);
            default -> arg_0 -> ((Logger)LOGGER).debug(arg_0);
        }).accept(BoltResponse.format(notification, query)));
    }

    static String format(Notification notification, String forQuery) {
        InputPosition position = notification.position();
        StringBuilder queryHint = new StringBuilder();
        String[] lines = forQuery.split("(\r\n|\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            queryHint.append("\t").append(line).append(LINE_SEPARATOR);
            if (i + 1 != position.line()) continue;
            queryHint.append("\t").append(Stream.generate(() -> " ").limit(position.column() - 1).collect(Collectors.joining())).append("^").append(System.lineSeparator());
        }
        return String.format("%s: %s%n%s%s", notification.code(), notification.title(), queryHint, notification.description());
    }
}

