/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Set;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoltResponse<T>
implements Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltResponse.class);
    protected final Result result;

    BoltResponse(Result result) {
        this.result = result;
    }

    public T next() {
        try {
            return this.fetchNext();
        }
        catch (ClientException ce) {
            LOGGER.debug("Error executing Cypher: {}, {}", (Object)ce.code(), (Object)ce.getMessage());
            throw new CypherException(ce.code(), ce.getMessage(), (Throwable)ce);
        }
    }

    protected abstract T fetchNext();

    public void close() {
        this.result.consume();
    }

    public String[] columns() {
        Record record;
        if (this.result.hasNext() && (record = this.result.peek()) != null) {
            Set columns = this.result.peek().asMap().keySet();
            return columns.toArray(new String[columns.size()]);
        }
        return new String[0];
    }
}

