/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.transaction;

import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltTransaction
extends AbstractTransaction {
    public static final String NEO_CLIENT_ERROR_SECURITY = "Neo.ClientError.Security";
    private final Transaction nativeTransaction;
    private final Session nativeSession;
    private final Logger LOGGER = LoggerFactory.getLogger(BoltTransaction.class);

    public BoltTransaction(TransactionManager transactionManager, Transaction transaction, Session session, Transaction.Type type) {
        super(transactionManager);
        this.nativeTransaction = transaction;
        this.nativeSession = session;
        this.type = type;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                this.LOGGER.debug("Rolling back native transaction: {}", (Object)this.nativeTransaction);
                if (this.nativeTransaction.isOpen()) {
                    this.nativeTransaction.failure();
                    this.nativeTransaction.close();
                    this.nativeSession.close();
                } else {
                    this.LOGGER.warn("Transaction is already closed");
                }
            }
        }
        catch (Exception e) {
            if (this.nativeSession.isOpen()) {
                this.nativeSession.close();
            }
            throw new TransactionException(e.getLocalizedMessage());
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        block10: {
            try {
                if (!this.transactionManager.canCommit()) break block10;
                this.LOGGER.debug("Committing native transaction: {}", (Object)this.nativeTransaction);
                if (this.nativeTransaction.isOpen()) {
                    this.nativeTransaction.success();
                    this.nativeTransaction.close();
                    this.nativeSession.close();
                    break block10;
                }
                throw new IllegalStateException("Transaction is already closed");
            }
            catch (ClientException ce) {
                if (this.nativeSession.isOpen()) {
                    this.nativeSession.close();
                }
                if (ce.neo4jErrorCode().startsWith(NEO_CLIENT_ERROR_SECURITY)) {
                    throw new ConnectionException("Security Error: " + ce.neo4jErrorCode() + ", " + ce.getMessage(), (Throwable)ce);
                }
                throw new CypherException("Error executing Cypher", (Throwable)ce, ce.neo4jErrorCode(), ce.getMessage());
            }
            catch (Exception e) {
                if (this.nativeSession.isOpen()) {
                    this.nativeSession.close();
                }
                throw new TransactionException(e.getLocalizedMessage());
            }
            finally {
                super.commit();
            }
        }
    }

    public Transaction nativeBoltTransaction() {
        return this.nativeTransaction;
    }
}

