/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.DefaultGraphRowModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.QueryStatisticsModel;
import org.neo4j.ogm.response.model.RelationshipModel;

public final class ObjectMapperFactory {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new Neo4jOgmJacksonModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.USE_LONG_FOR_INTS, true);

    public static ObjectMapper objectMapper() {
        return mapper;
    }

    private ObjectMapperFactory() {
    }

    static class Neo4jOgmJacksonModule
    extends SimpleModule {
        Neo4jOgmJacksonModule() {
        }

        public void setupModule(Module.SetupContext context) {
            context.setMixInAnnotations(NodeModel.class, NodeModelMixin.class);
            context.setMixInAnnotations(DefaultGraphModel.class, DefaultGraphModelMixin.class);
            context.setMixInAnnotations(DefaultGraphRowModel.class, DefaultGraphRowModelMixin.class);
            context.setMixInAnnotations(QueryStatisticsModel.class, IgnoreUnknownPropertiesMixin.class);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static abstract class IgnoreUnknownPropertiesMixin {
        IgnoreUnknownPropertiesMixin() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static abstract class DefaultGraphRowModelMixin {
        @JsonCreator
        DefaultGraphRowModelMixin(@JsonProperty(value="graph") DefaultGraphModel graph, @JsonProperty(value="row") Object[] row) {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static abstract class DefaultGraphModelMixin {
        DefaultGraphModelMixin() {
        }

        @JsonSetter(value="nodes")
        public void addNodes(NodeModel[] additionalNodes) {
        }

        @JsonSetter(value="relationships")
        public void addRelationships(RelationshipModel[] additionalRelationships) {
        }
    }

    static abstract class NodeModelMixin {
        @JsonCreator
        NodeModelMixin(@JsonProperty(value="id") Long id) {
        }
    }
}

