/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedValueIndexReader;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;

class TrigramIndex
extends AbstractLuceneIndex<ValueIndexReader> {
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator();

    TrigramIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexPartitionFactory partitionFactory, Config config) {
        super(indexStorage, partitionFactory, descriptor, config);
        this.samplingConfig = samplingConfig;
    }

    @Override
    public void drop() {
        this.taskCoordinator.cancel();
        try {
            this.taskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        super.drop();
    }

    @Override
    protected TrigramIndexReader createSimpleReader(List<AbstractIndexPartition> partitions, IndexUsageTracker usageTracker) throws IOException {
        AbstractIndexPartition searcher = TrigramIndex.getFirstPartition(partitions);
        return new TrigramIndexReader(searcher.acquireSearcher(), this.descriptor, this.samplingConfig, this.taskCoordinator, usageTracker);
    }

    @Override
    protected PartitionedValueIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions, IndexUsageTracker usageTracker) throws IOException {
        List<ValueIndexReader> readers = TrigramIndex.acquireSearchers(partitions).stream().map(partitionSearcher -> new TrigramIndexReader((SearcherReference)partitionSearcher, this.descriptor, this.samplingConfig, this.taskCoordinator, usageTracker)).toList();
        return new PartitionedValueIndexReader(this.descriptor, readers, usageTracker);
    }
}

