/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramTokenStream;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class TrigramDocumentStructure {
    static final String ENTITY_ID_KEY = "id";
    static final String TRIGRAM_VALUE_KEY = "0";

    TrigramDocumentStructure() {
    }

    static Term newTermForChangeOrRemove(long nodeId) {
        return new Term(ENTITY_ID_KEY, "" + nodeId);
    }

    static Document createLuceneDocument(long id, Value value) {
        Document document = new Document();
        StringField idField = new StringField(ENTITY_ID_KEY, Long.toString(id), Field.Store.NO);
        NumericDocValuesField idValueField = new NumericDocValuesField(ENTITY_ID_KEY, id);
        document.add((IndexableField)idField);
        document.add((IndexableField)idValueField);
        if (value.valueGroup() == ValueGroup.TEXT) {
            TrigramTokenStream tokenStream = new TrigramTokenStream(value.asObject().toString());
            TrigramField valueField = new TrigramField(TRIGRAM_VALUE_KEY, tokenStream);
            document.add((IndexableField)valueField);
        }
        return document;
    }

    private static class TrigramField
    extends Field {
        private static final FieldType TYPE = new FieldType();

        public TrigramField(String name, TokenStream tokenStream) {
            super(name, tokenStream, (IndexableFieldType)TYPE);
        }

        static {
            TYPE.setOmitNorms(true);
            TYPE.setIndexOptions(IndexOptions.DOCS);
            TYPE.setTokenized(true);
            TYPE.setStored(false);
            TYPE.freeze();
        }
    }
}

