/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.MinimalLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.ValueIndexReader;

public class MinimalDatabaseIndex<READER extends ValueIndexReader>
extends AbstractDatabaseIndex<MinimalLuceneIndex<READER>, READER> {
    public MinimalDatabaseIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, Config config) {
        super(new MinimalLuceneIndex(indexStorage, new ReadOnlyIndexPartitionFactory(), descriptor, config));
    }

    @Override
    public void drop() {
        ((MinimalLuceneIndex)this.luceneIndex).drop();
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException("Index creation in read only mode is not supported.");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        ((MinimalLuceneIndex)this.luceneIndex).close();
    }

    @Override
    public ResourceIterator<Path> snapshot() throws IOException {
        return ((MinimalLuceneIndex)this.luceneIndex).snapshot();
    }

    @Override
    public void maybeRefreshBlocking() {
    }

    @Override
    public LuceneIndexWriter getIndexWriter() {
        throw new UnsupportedOperationException("Can't get index writer for read only lucene index.");
    }

    @Override
    public void markAsOnline() {
        throw new UnsupportedOperationException("Can't mark read only index.");
    }
}

