/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.values.storable.ValueGroup;

public abstract class AbstractTextIndexReader
implements ValueIndexReader {
    protected final IndexDescriptor descriptor;
    protected final SearcherReference searcherReference;
    protected final IndexSamplingConfig samplingConfig;
    protected final TaskCoordinator taskCoordinator;

    protected AbstractTextIndexReader(IndexDescriptor descriptor, SearcherReference searcherReference, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this.descriptor = descriptor;
        this.searcherReference = searcherReference;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public void query(IndexProgressor.EntityValueClient client, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        AbstractTextIndexReader.validateQuery(predicates);
        context.monitor().queried(this.descriptor);
        PropertyIndexQuery predicate = predicates[0];
        Query query = this.toLuceneQuery(predicate);
        IndexProgressor progressor = this.search(query).getIndexProgressor(this.entityIdFieldKey(), client);
        boolean needStoreFilter = this.needStoreFilter(predicate);
        client.initialize(this.descriptor, progressor, accessMode, false, needStoreFilter, constraints, new PropertyIndexQuery[]{predicate});
    }

    protected abstract Query toLuceneQuery(PropertyIndexQuery var1);

    protected abstract String entityIdFieldKey();

    protected abstract boolean needStoreFilter(PropertyIndexQuery var1);

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext context, PropertyIndexQuery ... query) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.searcherReference.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    protected IndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }

    private DocValuesCollector search(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void validateQuery(PropertyIndexQuery ... predicates) {
        IndexType key = IndexType.TEXT;
        if (predicates.length > 1) {
            throw new IllegalArgumentException(String.format("Tried to query a %s index with a composite query. Composite queries are not supported by a %s index. Query was: %s ", key, key, Arrays.toString(predicates)));
        }
        PropertyIndexQuery predicate = predicates[0];
        if (predicate.valueGroup() != ValueGroup.TEXT && predicate.type() != IndexQuery.IndexQueryType.ALL_ENTRIES) {
            throw new IllegalArgumentException(String.format("Index query not supported for %s index. Query: %s", key, predicate));
        }
    }
}

