/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.api.ArrayEncoder;
import org.neo4j.util.Preconditions;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LuceneIndexValueValidator
implements IndexValueValidator {
    public static final int MAX_TERM_LENGTH = 32766;
    private final IndexDescriptor descriptor;
    private final TokenNameLookup tokenNameLookup;
    private final ElementIdMapper elementIdMapper;
    private final int checkThreshold;

    public LuceneIndexValueValidator(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper) {
        this.descriptor = descriptor;
        this.tokenNameLookup = tokenNameLookup;
        this.elementIdMapper = elementIdMapper;
        this.checkThreshold = 6553;
    }

    public void validate(long entityId, Value ... values) {
        for (Value value : values) {
            this.validate(entityId, value);
        }
    }

    private void validate(long entityId, Value value) {
        Preconditions.checkArgument((value != null && value != Values.NO_VALUE ? 1 : 0) != 0, (String)"Null value");
        if (Values.isTextValue((Object)value) && ((TextValue)value).length() >= this.checkThreshold) {
            int length = ((TextValue)value).stringValue().getBytes().length;
            this.validateActualLength(entityId, length);
        }
        if (Values.isArrayValue((Value)value)) {
            this.validateActualLength(entityId, ArrayEncoder.encode(value).getBytes().length);
        }
    }

    private void validateActualLength(long entityId, int length) {
        if (length > 32766) {
            IndexValueValidator.throwSizeViolationException((IndexDescriptor)this.descriptor, (TokenNameLookup)this.tokenNameLookup, (ElementIdMapper)this.elementIdMapper, (long)entityId, (int)length);
        }
    }
}

