/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.vector.VectorCandidate;

abstract class VectorDocumentStructure {
    static final String ENTITY_ID_KEY = "id";

    VectorDocumentStructure() {
    }

    static Term newTermForChangeOrRemove(long id) {
        return new Term(ENTITY_ID_KEY, Long.toString(id));
    }

    abstract String vectorValueKeyFor(int var1);

    Document createLuceneDocument(long id, VectorCandidate candidate, VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction) {
        float[] vector = similarityFunction.maybeToValidVector(candidate);
        if (vector == null) {
            return null;
        }
        Document document = new Document();
        StringField idField = new StringField(ENTITY_ID_KEY, Long.toString(id), Field.Store.NO);
        NumericDocValuesField idValueField = new NumericDocValuesField(ENTITY_ID_KEY, id);
        KnnFloatVectorField valueField = new KnnFloatVectorField(this.vectorValueKeyFor(vector.length), vector, similarityFunction.toLucene());
        document.add((IndexableField)idField);
        document.add((IndexableField)idValueField);
        document.add((IndexableField)valueField);
        return document;
    }
}

