/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.OptionalInt;
import org.apache.lucene.codecs.Codec;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigModes;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructures;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexAccessor;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexBuilder;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexCapability;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexPopulator;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexSettingsValidator;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.impl.schema.vector.codec.VectorCodecV2;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.vector.VectorCandidate;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public class VectorIndexProvider
extends AbstractLuceneIndexProvider {
    private final VectorIndexVersion version;
    private final VectorIndexSettingsValidator settingsValidator;
    private final VectorDocumentStructure documentStructure;
    private final FileSystemAbstraction fileSystem;
    private final JobScheduler scheduler;

    public VectorIndexProvider(VectorIndexVersion version, FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker, JobScheduler scheduler) {
        super(version.minimumRequiredKernelVersion(), IndexType.VECTOR, version.descriptor(), fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker);
        this.version = version;
        this.settingsValidator = version.indexSettingValidator();
        this.documentStructure = VectorDocumentStructures.documentStructureFor(version);
        this.fileSystem = fileSystem;
        this.scheduler = scheduler;
    }

    @Override
    public IndexPrototype validatePrototype(IndexPrototype prototype) {
        prototype = super.validatePrototype(prototype);
        VectorIndexConfig vectorIndexConfig = this.settingsValidator.validateToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(prototype.getIndexConfig()));
        return prototype.withIndexConfig(vectorIndexConfig.config());
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        VectorIndexConfig vectorIndexConfig = this.settingsValidator.trustIsValidToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(descriptor.getIndexConfig()));
        OptionalInt dimensions = vectorIndexConfig.dimensions();
        VectorCodecV2 codec = new VectorCodecV2(vectorIndexConfig);
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(IndexWriterConfigModes.VectorModes.POPULATION, this.config).withCodec((Codec)codec);
        DatabaseIndex<VectorIndexReader> luceneIndex = ((VectorIndexBuilder)((VectorIndexBuilder)VectorIndexBuilder.create(descriptor, vectorIndexConfig, this.documentStructure, this.readOnlyChecker, this.config).withFileSystem(this.fileSystem)).withIndexStorage(this.getIndexStorage(descriptor.getId()))).withWriterConfig(writerConfigBuilder::build).build();
        if (luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        IgnoreStrategy ignoreStrategy = new IgnoreStrategy(this.version, dimensions);
        VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction = this.vectorSimilarityFunctionFrom(vectorIndexConfig);
        return new VectorIndexPopulator(luceneIndex, ignoreStrategy, this.documentStructure, similarityFunction);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        VectorIndexConfig vectorIndexConfig = this.settingsValidator.trustIsValidToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(descriptor.getIndexConfig()));
        VectorIndexBuilder builder = (VectorIndexBuilder)VectorIndexBuilder.create(descriptor, vectorIndexConfig, this.documentStructure, this.readOnlyChecker, this.config).withIndexStorage(this.getIndexStorage(descriptor.getId()));
        if (readOnly) {
            builder = (VectorIndexBuilder)builder.permanentlyReadOnly();
        }
        DatabaseIndex<VectorIndexReader> luceneIndex = builder.build();
        luceneIndex.open();
        VectorIndexProvider.forceMergeSegments(this.scheduler, luceneIndex);
        IgnoreStrategy ignoreStrategy = new IgnoreStrategy(this.version, vectorIndexConfig.dimensions());
        VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction = this.vectorSimilarityFunctionFrom(vectorIndexConfig);
        return new VectorIndexAccessor(luceneIndex, descriptor, ignoreStrategy, this.documentStructure, similarityFunction);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(VectorIndexProvider.capability(this.version, index.getIndexConfig())) : index;
    }

    public static IndexCapability capability(VectorIndexVersion version, IndexConfig config) {
        VectorIndexConfig vectorIndexConfig = version.indexSettingValidator().trustIsValidToVectorIndexConfig((SettingsAccessor)new SettingsAccessor.IndexConfigAccessor(config));
        return new VectorIndexCapability(new IgnoreStrategy(version, vectorIndexConfig.dimensions()), vectorIndexConfig.similarityFunction());
    }

    private VectorSimilarityFunctions.LuceneVectorSimilarityFunction vectorSimilarityFunctionFrom(VectorIndexConfig vectorIndexConfig) {
        VectorSimilarityFunction vectorSimilarityFunction = vectorIndexConfig.similarityFunction();
        if (!(vectorSimilarityFunction instanceof VectorSimilarityFunctions.LuceneVectorSimilarityFunction)) {
            throw new IllegalArgumentException("'%s' vector similarity function is expected to be compatible with Lucene. Provided: %s".formatted(vectorSimilarityFunction.name(), vectorSimilarityFunction));
        }
        VectorSimilarityFunctions.LuceneVectorSimilarityFunction luceneSimilarityFunction = (VectorSimilarityFunctions.LuceneVectorSimilarityFunction)vectorSimilarityFunction;
        return luceneSimilarityFunction;
    }

    private static void forceMergeSegments(JobScheduler scheduler, DatabaseIndex<?> luceneIndex) {
        scheduler.schedule(Group.INDEX_POPULATION, JobMonitoringParams.systemJob((String)"Merging vector index segments"), IOUtils.uncheckedRunnable(() -> VectorIndexProvider.forceMergeSegments(luceneIndex)));
    }

    private static void forceMergeSegments(DatabaseIndex<?> luceneIndex) throws IOException {
        IOException exception = null;
        for (AbstractIndexPartition partition : luceneIndex.getPartitions()) {
            try {
                partition.getIndexWriter().forceMerge(Integer.MAX_VALUE);
            }
            catch (IOException e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                    continue;
                }
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    record IgnoreStrategy(VectorIndexVersion version, OptionalInt dimensions) implements IndexUpdateIgnoreStrategy
    {
        public boolean ignore(Value ... values) {
            if (values.length != 1) {
                return true;
            }
            Value value = values[0];
            if (!this.version.acceptsValueInstanceType(value)) {
                return true;
            }
            VectorCandidate candidate = VectorCandidate.maybeFrom((AnyValue)value);
            return candidate == null || this.dimensions.isPresent() && candidate.dimensions() != this.dimensions.getAsInt() || this.dimensions.isEmpty() && (candidate.dimensions() < 1 || candidate.dimensions() > this.version.maxDimensions());
        }
    }
}

