/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigModes;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndex;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexReader;
import org.neo4j.kernel.api.impl.schema.vector.codec.VectorCodecV2;

class VectorIndexBuilder
extends AbstractLuceneIndexBuilder<VectorIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final VectorIndexConfig vectorIndexConfig;
    private final VectorDocumentStructure documentStructure;
    private final Config config;
    private Supplier<IndexWriterConfig> writerConfigFactory;

    private VectorIndexBuilder(IndexDescriptor descriptor, VectorIndexConfig vectorIndexConfig, VectorDocumentStructure documentStructure, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        super(readOnlyChecker);
        this.descriptor = descriptor;
        this.vectorIndexConfig = vectorIndexConfig;
        this.documentStructure = documentStructure;
        this.config = config;
        VectorCodecV2 codec = new VectorCodecV2(vectorIndexConfig);
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(IndexWriterConfigModes.VectorModes.STANDARD, config).withCodec((Codec)codec);
        this.writerConfigFactory = writerConfigBuilder::build;
    }

    static VectorIndexBuilder create(IndexDescriptor descriptor, VectorIndexConfig vectorIndexConfig, VectorDocumentStructure documentStructure, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        return new VectorIndexBuilder(descriptor, vectorIndexConfig, documentStructure, readOnlyChecker, config);
    }

    VectorIndexBuilder withWriterConfig(Supplier<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    DatabaseIndex<VectorIndexReader> build() {
        PartitionedIndexStorage storage = this.storageBuilder.build();
        VectorIndex index = new VectorIndex(storage, new WritableIndexPartitionFactory(this.writerConfigFactory), this.documentStructure, this.descriptor, this.vectorIndexConfig, this.config);
        return new WritableDatabaseIndex(index, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

