/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedValueIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.TextIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

class TextIndex
extends AbstractLuceneIndex<ValueIndexReader> {
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator();

    TextIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexPartitionFactory partitionFactory, Config config) {
        super(indexStorage, partitionFactory, descriptor, config);
        this.samplingConfig = samplingConfig;
    }

    @Override
    public void drop() {
        this.taskCoordinator.cancel();
        try {
            this.taskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        super.drop();
    }

    @Override
    protected TextIndexReader createSimpleReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        AbstractIndexPartition searcher = TextIndex.getFirstPartition(partitions);
        return new TextIndexReader(searcher.acquireSearcher(), this.descriptor, this.samplingConfig, this.taskCoordinator, usageTracker);
    }

    @Override
    protected PartitionedValueIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions, IndexUsageTracking usageTracker) throws IOException {
        List<ValueIndexReader> readers = TextIndex.acquireSearchers(partitions).stream().map(partitionSearcher -> new TextIndexReader((SearcherReference)partitionSearcher, this.descriptor, this.samplingConfig, this.taskCoordinator, IndexUsageTracking.NO_USAGE_TRACKING)).toList();
        return new PartitionedValueIndexReader(this.descriptor, readers, usageTracker);
    }
}

