/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.util.Locale;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.Value;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VectorIndexVersion {
    UNKNOWN(null, KernelVersion.EARLIEST, 0, new VectorSimilarityFunction[0]){

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return false;
        }
    }
    ,
    V1_0("1.0", KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED, 2048, new VectorSimilarityFunction[]{VectorSimilarityFunctions.EUCLIDEAN, VectorSimilarityFunctions.SIMPLE_COSINE}){

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return candidate instanceof FloatingPointArray;
        }
    }
    ,
    V2_0("2.0", KernelVersion.VERSION_VECTOR_2_INTRODUCED, 4096, new VectorSimilarityFunction[]{VectorSimilarityFunctions.EUCLIDEAN, VectorSimilarityFunctions.L2_NORM_COSINE}){

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return candidate instanceof NumberArray;
        }
    };

    public static final ImmutableList<VectorIndexVersion> KNOWN_VERSIONS;
    private static final String DESCRIPTOR_KEY = "vector";
    private final KernelVersion minimumRequiredKernelVersion;
    private final IndexProviderDescriptor descriptor;
    private final int maxDimensions;
    private final ImmutableMap<String, VectorSimilarityFunction> similarityFunctions;

    public static VectorIndexVersion latestSupportedVersion(KernelVersion kernelVersion) {
        for (VectorIndexVersion version : KNOWN_VERSIONS.asReversed()) {
            if (!kernelVersion.isAtLeast(version.minimumRequiredKernelVersion)) continue;
            return version;
        }
        return UNKNOWN;
    }

    public static VectorIndexVersion fromDescriptor(IndexProviderDescriptor descriptor) {
        for (VectorIndexVersion version : KNOWN_VERSIONS.asReversed()) {
            if (!version.descriptor.equals((Object)descriptor)) continue;
            return version;
        }
        return UNKNOWN;
    }

    private VectorIndexVersion(String version, KernelVersion minimumRequiredKernelVersion, int maxDimensions, VectorSimilarityFunction ... supportedSimilarityFunctions) {
        this.minimumRequiredKernelVersion = minimumRequiredKernelVersion;
        this.descriptor = version != null ? new IndexProviderDescriptor(DESCRIPTOR_KEY, version) : IndexProviderDescriptor.UNDECIDED;
        this.maxDimensions = maxDimensions;
        MutableMap similarityFunctions = Maps.mutable.withInitialCapacity(supportedSimilarityFunctions.length);
        for (VectorSimilarityFunction similarityFunction : supportedSimilarityFunctions) {
            similarityFunctions.put((Object)similarityFunction.name().toUpperCase(Locale.ROOT), (Object)similarityFunction);
        }
        this.similarityFunctions = similarityFunctions.toImmutable();
    }

    public KernelVersion minimumRequiredKernelVersion() {
        return this.minimumRequiredKernelVersion;
    }

    public IndexProviderDescriptor descriptor() {
        return this.descriptor;
    }

    public int maxDimensions() {
        return this.maxDimensions;
    }

    public abstract boolean acceptsValueInstanceType(Value var1);

    public VectorSimilarityFunction similarityFunction(String name) {
        VectorSimilarityFunction similarityFunction = (VectorSimilarityFunction)this.similarityFunctions.get((Object)name.toUpperCase(Locale.ROOT));
        if (similarityFunction == null) {
            throw new IllegalArgumentException("'%s' is an unsupported vector similarity function for %s. Supported: %s".formatted(name, this.descriptor.name(), this.similarityFunctions.keysView()));
        }
        return similarityFunction;
    }

    @VisibleForTesting
    public RichIterable<VectorSimilarityFunction> supportedSimilarityFunctions() {
        return this.similarityFunctions.valuesView();
    }

    static {
        KNOWN_VERSIONS = Lists.mutable.with((Object[])VectorIndexVersion.values()).without((Object)UNKNOWN).toImmutableList();
    }
}

