/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.api.impl.index.LuceneSettings;
import org.neo4j.kernel.api.impl.index.OnThreadConcurrentMergeScheduler;
import org.neo4j.kernel.api.impl.schema.LuceneIndexType;
import org.neo4j.kernel.api.impl.schema.vector.VectorUtils;
import org.neo4j.kernel.api.impl.schema.vector.codec.VectorCodecV2;

public final class IndexWriterConfigs {
    private static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();

    private IndexWriterConfigs() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterConfig standard(LuceneIndexType index, Config config, IndexConfig indexConfig) {
        return IndexWriterConfigs.standard(index, config, KEYWORD_ANALYZER, indexConfig);
    }

    public static IndexWriterConfig standard(LuceneIndexType index, Config config, Analyzer analyzer, IndexConfig indexConfig) {
        IndexWriterConfig writerConfig = new IndexWriterConfig(analyzer);
        writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_writer_max_buffered_docs)).intValue());
        writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        writerConfig.setUseCompoundFile(true);
        writerConfig.setMaxFullFlushMergeWaitMillis(0L);
        writerConfig.setRAMBufferSizeMB(((Double)config.get(LuceneSettings.lucene_standard_ram_buffer_size)).doubleValue());
        if (index == LuceneIndexType.VECTOR) {
            writerConfig.setCodec((Codec)new VectorCodecV2(VectorUtils.vectorDimensionsFrom(indexConfig)));
        }
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(((Double)config.get(LuceneSettings.lucene_nocfs_ratio)).doubleValue());
        mergePolicy.setMinMergeMB(((Double)config.get(LuceneSettings.lucene_min_merge)).doubleValue());
        mergePolicy.setMergeFactor(((Integer)config.get(index == LuceneIndexType.VECTOR ? LuceneSettings.vector_standard_merge_factor : LuceneSettings.lucene_merge_factor)).intValue());
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }

    public static IndexWriterConfig population(LuceneIndexType index, Config config, IndexConfig indexConfig) {
        return IndexWriterConfigs.population(index, config, KEYWORD_ANALYZER, indexConfig);
    }

    public static IndexWriterConfig population(LuceneIndexType index, Config config, Analyzer analyzer, IndexConfig indexConfig) {
        MergePolicy mergePolicy;
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard(index, config, analyzer, indexConfig);
        writerConfig.setMaxBufferedDocs(((Integer)config.get(LuceneSettings.lucene_population_max_buffered_docs)).intValue());
        writerConfig.setRAMBufferSizeMB(((Double)config.get(index == LuceneIndexType.VECTOR ? LuceneSettings.vector_population_ram_buffer_size : LuceneSettings.lucene_population_ram_buffer_size)).doubleValue());
        if (index == LuceneIndexType.VECTOR && (mergePolicy = writerConfig.getMergePolicy()) instanceof LogMergePolicy) {
            LogMergePolicy mergePolicy2 = (LogMergePolicy)mergePolicy;
            mergePolicy2.setMergeFactor(((Integer)config.get(LuceneSettings.vector_population_merge_factor)).intValue());
        }
        if (((Boolean)config.get(LuceneSettings.lucene_population_serial_merge_scheduler)).booleanValue()) {
            writerConfig.setMergeScheduler((MergeScheduler)new OnThreadConcurrentMergeScheduler());
        }
        return writerConfig;
    }

    public static IndexWriterConfig transactionState(LuceneIndexType index, Config config, Analyzer analyzer, IndexConfig indexConfig) {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard(index, config, analyzer, indexConfig);
        writerConfig.setCommitOnClose(false);
        return writerConfig;
    }
}

