/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector.codec;

import java.io.IOException;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene95.Lucene95HnswVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;

public class LuceneKnnVectorFormatV1
extends KnnVectorsFormat {
    private static final String LUCENE_VECTOR_FORMAT_V1_NAME = "LuceneKnnVectorFormatV1";
    private final Lucene95HnswVectorsFormat vectorsFormat;
    private final int maxDimensions;

    public LuceneKnnVectorFormatV1() {
        this(VectorIndexVersion.V1_0.maxDimensions());
    }

    public LuceneKnnVectorFormatV1(int maxDimensions) {
        super(LUCENE_VECTOR_FORMAT_V1_NAME);
        this.maxDimensions = maxDimensions;
        this.vectorsFormat = new Lucene95HnswVectorsFormat();
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.vectorsFormat.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.vectorsFormat.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return this.maxDimensions;
    }
}

