/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;

class VectorQueryFactory {
    VectorQueryFactory() {
    }

    static Query getById(long entityId) {
        Term term = VectorDocumentStructure.newTermForChangeOrRemove(entityId);
        return new TermQuery(term);
    }

    static Query approximateNearestNeighbors(float[] query, int k) {
        return new KnnFloatVectorQuery("vector", query, k);
    }

    static MatchAllDocsQuery allValues() {
        return new MatchAllDocsQuery();
    }
}

